% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumDelTri}
\alias{NumDelTri}
\title{Number of Delaunay triangles based on a 2D data set}
\usage{
NumDelTri(Yp)
}
\arguments{
\item{Yp}{A set of 2D points which constitute the vertices of Delaunay triangles.}
}
\value{
Number of Delaunay triangles based on \code{Yp} points.
}
\description{
Returns the number of Delaunay triangles based on the 2D set of points \code{Yp}.
See (\insertCite{okabe:2000,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and
the corresponding algorithm.
}
\examples{
ny<-10

set.seed(1)
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

NumDelTri(Yp)
NumDelTri(Yp[1:3,])

dat.fr<-data.frame(a=Yp)
NumDelTri(dat.fr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotDeltri}}
}
\author{
Elvan Ceyhan
}
