% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{redges.tri.cent}
\alias{redges.tri.cent}
\title{The indices of the \code{M}-edge regions in a triangle that contains the points in a give data set}
\usage{
redges.tri.cent(Dt, tri, M)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points for which indices of the edge regions
containing them are to be determined.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}
}
\value{
A list with the elements
\item{re}{Indices (i.e., a vector of indices) of the edges whose region contains points in \code{Dt}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index opposite to edge
whose index is given in re.}
\item{desc}{Description of the edge labels as "Edge labels are AB=1, BC=2, and AC=3".}
}
\description{
Returns the indices of the edges whose regions contain the points in data set \code{Dt} in
a triangle \eqn{tri=T(A,B,C)} and edge regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}
(see the plots in the example for illustrations).

The vertices of the  triangle \code{tri} are labeled as
1=A,2=B, and 3=C also according to the row number the vertex is recorded in \code{tri}
and the corresponding edges are 1=BC, 2=AC, and 3=AB.

If a point in \code{Dt} is not inside \code{tri}, then the function yields \code{NA} as output for that entry.
The corresponding edge region is the polygon
with the vertex, \code{M}, and vertices other than the non-adjacent vertex, i.e., edge region 1 is the triangle
\eqn{T(B,M,C)}, edge region 2 is \eqn{T(A,M,C)} and edge region 3 is \eqn{T(A,B,M)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

M<-c(1.6,1.2)

P<-c(.4,.2)
redges.tri.cent(P,Tr,M)

P<-c(1.8,.5)
redges.tri.cent(P,Tr,M)

P<-c(10.5,1.6)
redges.tri.cent(P,Tr,M)

n<-10  #try also n<-20
set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

re<-redges.tri.cent(dat,Tr,M)
re

D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=".",col=1)
L<-Tr; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]+c(-.02,.03,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(.05,.06,-.05,-.02)
yc<-txt[,2]+c(.03,.03,.05,-.08)
txt.str<-c("M","re=2","re=3","re=1")
text(xc,yc,txt.str)
text(dat,labels=factor(re$re))

redges.tri.cent(dat,Tr,M)

dat.fr<-data.frame(a=dat)
redges.tri.cent(dat.fr,Tr,M)

dat.fr<-data.frame(a=Tr)
redges.tri.cent(dat,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{redges.triCM}}, \code{\link{rverts.tri.cent}} and \code{\link{rverts.tri.nd}}
}
