% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPEint}
\alias{NumArcsPEint}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one interval case}
\usage{
NumArcsPEint(dat, r, c = 0.5, int)
}
\arguments{
\item{dat}{A set of 1D points which constitute the vertices of PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default=0.5}

\item{int}{A vector of two real numbers representing an interval.}
}
\value{
Number of arcs for the PE-PCD whose vertices are the 1D data set, \code{dat},
with expansion parameter, \eqn{r \ge 1}, and centrality parameter, \code{c} in \eqn{(0,1)}.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
whose vertices are the 1D data set \code{dat} in the one-interval case.

The data points could be inside or outside the interval is \eqn{int=(a,b)}. PE proximity region is constructed
with an expansion parameter \eqn{r \ge 1} and a centrality parameter \code{c} in \eqn{(0,1)}.

The PE proximity region is constructed for both points inside and outside the interval, hence
the arcs may exist for all points inside or outside the interval.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

n<-10
dat<-runif(n,a,b)
NumArcsPEint(dat,r,c,int)

NumArcsPEint(3,r,c,int)

NumArcsPEint(dat,r,c=.3,int)

NumArcsPEint(dat,r=1.5,c,int)

n<-10  #try also n<-20
dat<-runif(n,a,b)

NumArcsPEint(dat,r,c,int)

dat<-runif(n,a+10,b+10)
NumArcsPEint(dat,r,c,int)

n<-10
dat<-runif(n,a,b)
NumArcsPEint(dat,r,c,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEmid1D}}, \code{\link{NumArcsPEend1D}}, and \code{\link{NumArcsCSint}}
}
