% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{fdrList}
\alias{fdrList}
\title{Auxiliary function}
\usage{
fdrList(snps, adjpval, list_selection, thresholds = seq(0.01, 0.5, length =
  100))
}
\arguments{
\item{snps}{a vector of indices.}

\item{adjpval}{a vector of adjusted p-values.}

\item{list_selection}{a vector of indices containing the list of all the SNPs under selection.}

\item{threholds}{a vector containing the control thresholds. Default value set to \code{seq(0.01,0.50,length=100)}.}
}
\description{
\code{fdrList} returns a list of false discovery rates for different thresholds.
}
\examples{
x <- read4pcadapt("geno3pops",option="example")
y <- pcadapt(x,K=3)
P <- pval(y)
ranked_snps <- order(P[,1],decreasing=FALSE)
adjpval <- p.adjust(sort(P[,1]),method="BH",n=length(P[,1]))
fdrList(ranked_snps,adjpval,1:250,thresholds=seq(0.05,0.5,length=10))
}
\keyword{internal}

