% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKR.R
\name{getkr}
\alias{getKR}
\alias{getkr}
\title{Extract (or "get") components from a \code{KRmodcomp} object.}
\usage{
getKR(object, name = c("ndf", "ddf", "Fstat", "p.value", "F.scaling",
  "FstatU", "p.valueU", "aux"))
}
\arguments{
\item{object}{A \code{KRmodcomp} object, which is the result of the
\code{KRmodcomp} function}

\item{name}{The available slots. If \code{name} is missing or \code{NULL}
then everything is returned.}
}
\description{
Extract (or "get") components from a \code{KRmodcomp} object,
    which is the result of the \code{KRmodcomp} function.
}
\examples{

data(beets, package='pbkrtest')
lg <- lmer(sugpct ~ block + sow + harvest + (1|block:harvest), 
              data=beets, REML=FALSE)
sm <- update(lg, .~. - harvest)
xx <- KRmodcomp(lg, sm)
getKR(xx, "ddf") # get denominator degrees of freedom.


}
\author{
Søren Højsgaard \email{sorenh@math.aau.dk}
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
    Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
    Models - The R Package pbkrtest., Journal of Statistical Software,
    58(10), 1-30., \url{http://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{KRmodcomp}}, \code{\link{PBmodcomp}},
    \code{\link{vcovAdj}}
}
\keyword{utilities}

