% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ssoadmin}
\alias{ssoadmin}
\title{AWS Single Sign-On Admin}
\usage{
ssoadmin(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
IAM Identity Center (successor to Single Sign-On) helps you securely
create, or connect, your workforce identities and manage their access
centrally across Amazon Web Services accounts and applications. IAM
Identity Center is the recommended approach for workforce authentication
and authorization in Amazon Web Services, for organizations of any size
and type.

IAM Identity Center uses the \code{sso} and \code{identitystore} API namespaces.

This reference guide provides information on single sign-on operations
which could be used for access management of Amazon Web Services
accounts. For information about IAM Identity Center features, see the
\href{https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html}{IAM Identity Center User Guide}.

Many operations in the IAM Identity Center APIs rely on identifiers for
users and groups, known as principals. For more information about how to
work with principals and principal IDs in IAM Identity Center, see the
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html}{Identity Store API Reference}.

Amazon Web Services provides SDKs that consist of libraries and sample
code for various programming languages and platforms (Java, Ruby, .Net,
iOS, Android, and more). The SDKs provide a convenient way to create
programmatic access to IAM Identity Center and other Amazon Web Services
services. For more information about the Amazon Web Services SDKs,
including how to download and install them, see \href{https://aws.amazon.com/developer/tools/}{Tools for Amazon Web Services}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssoadmin(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:ssoadmin_attach_customer_managed_policy_reference_to_permission_set]{attach_customer_managed_policy_reference_to_permission_set} \tab Attaches the specified customer managed policy to the specified PermissionSet\cr
\link[paws.security.identity:ssoadmin_attach_managed_policy_to_permission_set]{attach_managed_policy_to_permission_set} \tab Attaches an Amazon Web Services managed policy ARN to a permission set\cr
\link[paws.security.identity:ssoadmin_create_account_assignment]{create_account_assignment} \tab Assigns access to a principal for a specified Amazon Web Services account using a specified permission set\cr
\link[paws.security.identity:ssoadmin_create_application]{create_application} \tab Creates an application in IAM Identity Center for the given application provider\cr
\link[paws.security.identity:ssoadmin_create_application_assignment]{create_application_assignment} \tab Grant application access to a user or group\cr
\link[paws.security.identity:ssoadmin_create_instance]{create_instance} \tab Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by Organizations or a member Amazon Web Services account in an organization\cr
\link[paws.security.identity:ssoadmin_create_instance_access_control_attribute_configuration]{create_instance_access_control_attribute_configuration} \tab Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_create_permission_set]{create_permission_set} \tab Creates a permission set within a specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_create_trusted_token_issuer]{create_trusted_token_issuer} \tab Creates a connection to a trusted token issuer in an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_delete_account_assignment]{delete_account_assignment} \tab Deletes a principal's access from a specified Amazon Web Services account using a specified permission set\cr
\link[paws.security.identity:ssoadmin_delete_application]{delete_application} \tab Deletes the association with the application\cr
\link[paws.security.identity:ssoadmin_delete_application_access_scope]{delete_application_access_scope} \tab Deletes an IAM Identity Center access scope from an application\cr
\link[paws.security.identity:ssoadmin_delete_application_assignment]{delete_application_assignment} \tab Revoke application access to an application by deleting application assignments for a user or group\cr
\link[paws.security.identity:ssoadmin_delete_application_authentication_method]{delete_application_authentication_method} \tab Deletes an authentication method from an application\cr
\link[paws.security.identity:ssoadmin_delete_application_grant]{delete_application_grant} \tab Deletes a grant from an application\cr
\link[paws.security.identity:ssoadmin_delete_inline_policy_from_permission_set]{delete_inline_policy_from_permission_set} \tab Deletes the inline policy from a specified permission set\cr
\link[paws.security.identity:ssoadmin_delete_instance]{delete_instance} \tab Deletes the instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_delete_instance_access_control_attribute_configuration]{delete_instance_access_control_attribute_configuration} \tab Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured\cr
\link[paws.security.identity:ssoadmin_delete_permissions_boundary_from_permission_set]{delete_permissions_boundary_from_permission_set} \tab Deletes the permissions boundary from a specified PermissionSet\cr
\link[paws.security.identity:ssoadmin_delete_permission_set]{delete_permission_set} \tab Deletes the specified permission set\cr
\link[paws.security.identity:ssoadmin_delete_trusted_token_issuer]{delete_trusted_token_issuer} \tab Deletes a trusted token issuer configuration from an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_describe_account_assignment_creation_status]{describe_account_assignment_creation_status} \tab Describes the status of the assignment creation request\cr
\link[paws.security.identity:ssoadmin_describe_account_assignment_deletion_status]{describe_account_assignment_deletion_status} \tab Describes the status of the assignment deletion request\cr
\link[paws.security.identity:ssoadmin_describe_application]{describe_application} \tab Retrieves the details of an application associated with an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_describe_application_assignment]{describe_application_assignment} \tab Retrieves a direct assignment of a user or group to an application\cr
\link[paws.security.identity:ssoadmin_describe_application_provider]{describe_application_provider} \tab Retrieves details about a provider that can be used to connect an Amazon Web Services managed application or customer managed application to IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_describe_instance]{describe_instance} \tab Returns the details of an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_describe_instance_access_control_attribute_configuration]{describe_instance_access_control_attribute_configuration} \tab Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_describe_permission_set]{describe_permission_set} \tab Gets the details of the permission set\cr
\link[paws.security.identity:ssoadmin_describe_permission_set_provisioning_status]{describe_permission_set_provisioning_status} \tab Describes the status for the given permission set provisioning request\cr
\link[paws.security.identity:ssoadmin_describe_trusted_token_issuer]{describe_trusted_token_issuer} \tab Retrieves details about a trusted token issuer configuration stored in an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_detach_customer_managed_policy_reference_from_permission_set]{detach_customer_managed_policy_reference_from_permission_set} \tab Detaches the specified customer managed policy from the specified PermissionSet\cr
\link[paws.security.identity:ssoadmin_detach_managed_policy_from_permission_set]{detach_managed_policy_from_permission_set} \tab Detaches the attached Amazon Web Services managed policy ARN from the specified permission set\cr
\link[paws.security.identity:ssoadmin_get_application_access_scope]{get_application_access_scope} \tab Retrieves the authorized targets for an IAM Identity Center access scope for an application\cr
\link[paws.security.identity:ssoadmin_get_application_assignment_configuration]{get_application_assignment_configuration} \tab Retrieves the configuration of PutApplicationAssignmentConfiguration\cr
\link[paws.security.identity:ssoadmin_get_application_authentication_method]{get_application_authentication_method} \tab Retrieves details about an authentication method used by an application\cr
\link[paws.security.identity:ssoadmin_get_application_grant]{get_application_grant} \tab Retrieves details about an application grant\cr
\link[paws.security.identity:ssoadmin_get_inline_policy_for_permission_set]{get_inline_policy_for_permission_set} \tab Obtains the inline policy assigned to the permission set\cr
\link[paws.security.identity:ssoadmin_get_permissions_boundary_for_permission_set]{get_permissions_boundary_for_permission_set} \tab Obtains the permissions boundary for a specified PermissionSet\cr
\link[paws.security.identity:ssoadmin_list_account_assignment_creation_status]{list_account_assignment_creation_status} \tab Lists the status of the Amazon Web Services account assignment creation requests for a specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_list_account_assignment_deletion_status]{list_account_assignment_deletion_status} \tab Lists the status of the Amazon Web Services account assignment deletion requests for a specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_list_account_assignments]{list_account_assignments} \tab Lists the assignee of the specified Amazon Web Services account with the specified permission set\cr
\link[paws.security.identity:ssoadmin_list_account_assignments_for_principal]{list_account_assignments_for_principal} \tab Retrieves a list of the IAM Identity Center associated Amazon Web Services accounts that the principal has access to\cr
\link[paws.security.identity:ssoadmin_list_accounts_for_provisioned_permission_set]{list_accounts_for_provisioned_permission_set} \tab Lists all the Amazon Web Services accounts where the specified permission set is provisioned\cr
\link[paws.security.identity:ssoadmin_list_application_access_scopes]{list_application_access_scopes} \tab Lists the access scopes and authorized targets associated with an application\cr
\link[paws.security.identity:ssoadmin_list_application_assignments]{list_application_assignments} \tab Lists Amazon Web Services account users that are assigned to an application\cr
\link[paws.security.identity:ssoadmin_list_application_assignments_for_principal]{list_application_assignments_for_principal} \tab Lists the applications to which a specified principal is assigned\cr
\link[paws.security.identity:ssoadmin_list_application_authentication_methods]{list_application_authentication_methods} \tab Lists all of the authentication methods supported by the specified application\cr
\link[paws.security.identity:ssoadmin_list_application_grants]{list_application_grants} \tab List the grants associated with an application\cr
\link[paws.security.identity:ssoadmin_list_application_providers]{list_application_providers} \tab Lists the application providers configured in the IAM Identity Center identity store\cr
\link[paws.security.identity:ssoadmin_list_applications]{list_applications} \tab Lists all applications associated with the instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_list_customer_managed_policy_references_in_permission_set]{list_customer_managed_policy_references_in_permission_set} \tab Lists all customer managed policies attached to a specified PermissionSet\cr
\link[paws.security.identity:ssoadmin_list_instances]{list_instances} \tab Lists the details of the organization and account instances of IAM Identity Center that were created in or visible to the account calling this API\cr
\link[paws.security.identity:ssoadmin_list_managed_policies_in_permission_set]{list_managed_policies_in_permission_set} \tab Lists the Amazon Web Services managed policy that is attached to a specified permission set\cr
\link[paws.security.identity:ssoadmin_list_permission_set_provisioning_status]{list_permission_set_provisioning_status} \tab Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_list_permission_sets]{list_permission_sets} \tab Lists the PermissionSets in an IAM Identity Center instance\cr
\link[paws.security.identity:ssoadmin_list_permission_sets_provisioned_to_account]{list_permission_sets_provisioned_to_account} \tab Lists all the permission sets that are provisioned to a specified Amazon Web Services account\cr
\link[paws.security.identity:ssoadmin_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are attached to a specified resource\cr
\link[paws.security.identity:ssoadmin_list_trusted_token_issuers]{list_trusted_token_issuers} \tab Lists all the trusted token issuers configured in an instance of IAM Identity Center\cr
\link[paws.security.identity:ssoadmin_provision_permission_set]{provision_permission_set} \tab The process by which a specified permission set is provisioned to the specified target\cr
\link[paws.security.identity:ssoadmin_put_application_access_scope]{put_application_access_scope} \tab Adds or updates the list of authorized targets for an IAM Identity Center access scope for an application\cr
\link[paws.security.identity:ssoadmin_put_application_assignment_configuration]{put_application_assignment_configuration} \tab Configure how users gain access to an application\cr
\link[paws.security.identity:ssoadmin_put_application_authentication_method]{put_application_authentication_method} \tab Adds or updates an authentication method for an application\cr
\link[paws.security.identity:ssoadmin_put_application_grant]{put_application_grant} \tab Adds a grant to an application\cr
\link[paws.security.identity:ssoadmin_put_inline_policy_to_permission_set]{put_inline_policy_to_permission_set} \tab Attaches an inline policy to a permission set\cr
\link[paws.security.identity:ssoadmin_put_permissions_boundary_to_permission_set]{put_permissions_boundary_to_permission_set} \tab Attaches an Amazon Web Services managed or customer managed policy to the specified PermissionSet as a permissions boundary\cr
\link[paws.security.identity:ssoadmin_tag_resource]{tag_resource} \tab Associates a set of tags with a specified resource\cr
\link[paws.security.identity:ssoadmin_untag_resource]{untag_resource} \tab Disassociates a set of tags from a specified resource\cr
\link[paws.security.identity:ssoadmin_update_application]{update_application} \tab Updates application properties\cr
\link[paws.security.identity:ssoadmin_update_instance]{update_instance} \tab Update the details for the instance of IAM Identity Center that is owned by the Amazon Web Services account\cr
\link[paws.security.identity:ssoadmin_update_instance_access_control_attribute_configuration]{update_instance_access_control_attribute_configuration} \tab Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC)\cr
\link[paws.security.identity:ssoadmin_update_permission_set]{update_permission_set} \tab Updates an existing permission set\cr
\link[paws.security.identity:ssoadmin_update_trusted_token_issuer]{update_trusted_token_issuer} \tab Updates the name of the trusted token issuer, or the path of a source attribute or destination attribute for a trusted token issuer configuration
}
}

\examples{
\dontrun{
svc <- ssoadmin()
svc$attach_customer_managed_policy_reference_to_permission_set(
  Foo = 123
)
}

}
