% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_retention}
\alias{s3_put_object_retention}
\title{This operation is not supported by directory buckets}
\usage{
s3_put_object_retention(
  Bucket,
  Key,
  Retention = NULL,
  RequestPayer = NULL,
  VersionId = NULL,
  BypassGovernanceRetention = NULL,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name that contains the object you want to apply this Object
Retention configuration to.

\strong{Access points} - When you use this action with an access point, you
must provide the alias of the access point in place of the bucket name
or specify the access point ARN. When using the access point ARN, you
must direct requests to the access point hostname. The access point
hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.}

\item{Key}{[required] The key name for the object that you want to apply this Object Retention
configuration to.}

\item{Retention}{The container element for the Object Retention configuration.}

\item{RequestPayer}{}

\item{VersionId}{The version ID for the object that you want to apply this Object
Retention configuration to.}

\item{BypassGovernanceRetention}{Indicates whether this action should bypass Governance-mode
restrictions.}

\item{ContentMD5}{The MD5 hash for the request body.

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
you use the SDK. This header will not provide any additional
functionality if you don't use the SDK. When you send this header, there
must be a corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}
}
\description{
This operation is not supported by directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_put_object_retention/} for full documentation.
}
\keyword{internal}
