% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_chap_credentials}
\alias{storagegateway_describe_chap_credentials}
\title{Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
credentials information for a specified iSCSI target, one for each
target-initiator pair}
\usage{
storagegateway_describe_chap_credentials(TargetARN)
}
\arguments{
\item{TargetARN}{[required] The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
\code{\link[=storagegateway_describe_storedi_scsi_volumes]{describe_storedi_scsi_volumes}}
operation to return to retrieve the TargetARN for specified VolumeARN.}
}
\value{
A list with the following syntax:\preformatted{list(
  ChapCredentials = list(
    list(
      TargetARN = "string",
      SecretToAuthenticateInitiator = "string",
      InitiatorName = "string",
      SecretToAuthenticateTarget = "string"
    )
  )
)
}
}
\description{
Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
credentials information for a specified iSCSI target, one for each
target-initiator pair. This operation is supported in the volume and
tape gateway types.
}
\section{Request syntax}{
\preformatted{svc$describe_chap_credentials(
  TargetARN = "string"
)
}
}

\examples{
\dontrun{
# Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
# credentials information for a specified iSCSI target, one for each
# target-initiator pair.
svc$describe_chap_credentials(
  TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12..."
)
}

}
\keyword{internal}
