% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_bucket_tagging}
\alias{s3control_get_bucket_tagging}
\title{This operation gets an Amazon S3 on Outposts bucket's tags}
\usage{
s3control_get_bucket_tagging(AccountId, Bucket)
}
\arguments{
\item{AccountId}{[required] The AWS account ID of the Outposts bucket.}

\item{Bucket}{[required] Specifies the bucket.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the bucket accessed in the format
\verb{arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/bucket/&lt;my-bucket-name&gt;}.
For example, to access the bucket \code{reports} through outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}
}
\description{
This operation gets an Amazon S3 on Outposts bucket's tags. To get an S3
bucket tags, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketTagging.html}{GetBucketTagging}
in the \emph{Amazon Simple Storage Service API}.

Returns the tag set associated with the Outposts bucket. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon Simple Storage Service Developer Guide}.

To use this operation, you must have permission to perform the
\code{GetBucketTagging} action. By default, the bucket owner has this
permission and can grant this permission to others.

\code{GetBucketTagging} has the following special error:
\itemize{
\item Error code: \code{NoSuchTagSetError}
\itemize{
\item Description: There is no tag set associated with the bucket.
}
}

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucketTagging.html#API_control_GetBucketTagging_Examples}{Examples}
section.

The following actions are related to \code{GetBucketTagging}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html}{PutBucketTagging}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucketTagging.html}{DeleteBucketTagging}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_tagging(
  AccountId = "string",
  Bucket = "string"
)
}
}

\keyword{internal}
