% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_disassociate_file_system_aliases}
\alias{fsx_disassociate_file_system_aliases}
\title{Use this action to disassociate, or remove, one or more Domain Name
Service (DNS) aliases from an Amazon FSx for Windows File Server file
system}
\usage{
fsx_disassociate_file_system_aliases(ClientRequestToken, FileSystemId,
  Aliases)
}
\arguments{
\item{ClientRequestToken}{}

\item{FileSystemId}{[required] Specifies the file system from which to disassociate the DNS aliases.}

\item{Aliases}{[required] An array of one or more DNS alias names to disassociate, or remove, from
the file system.}
}
\description{
Use this action to disassociate, or remove, one or more Domain Name
Service (DNS) aliases from an Amazon FSx for Windows File Server file
system. If you attempt to disassociate a DNS alias that is not
associated with the file system, Amazon FSx responds with a 400 Bad
Request. For more information, see \href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html}{Working with DNS Aliases}.

The system generated response showing the DNS aliases that Amazon FSx is
attempting to disassociate from the file system. Use the API operation
to monitor the status of the aliases Amazon FSx is disassociating with
the file system.
}
\section{Request syntax}{
\preformatted{svc$disassociate_file_system_aliases(
  ClientRequestToken = "string",
  FileSystemId = "string",
  Aliases = list(
    "string"
  )
)
}
}

\keyword{internal}
