% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_operations.R
\name{account_put_contact_information}
\alias{account_put_contact_information}
\title{Updates the primary contact information of an Amazon Web Services
account}
\usage{
account_put_contact_information(AccountId = NULL, ContactInformation)
}
\arguments{
\item{AccountId}{Specifies the 12-digit account ID number of the Amazon Web Services
account that you want to access or modify with this operation. If you
don't specify this parameter, it defaults to the Amazon Web Services
account of the identity used to call the operation. To use this
parameter, the caller must be an identity in the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account}{organization's management account}
or a delegated administrator account. The specified account ID must also
be a member account in the same organization. The organization must have
\href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html}{all features enabled},
and the organization must have \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{trusted access}
enabled for the Account Management service, and optionally a \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{delegated admin}
account assigned.

The management account can't specify its own \code{AccountId}. It must call
the operation in standalone context by not including the \code{AccountId}
parameter.

To call this operation on an account that is not a member of an
organization, don't specify this parameter. Instead, call the operation
using an identity belonging to the account whose contacts you wish to
retrieve or modify.}

\item{ContactInformation}{[required] Contains the details of the primary contact information associated with
an Amazon Web Services account.}
}
\description{
Updates the primary contact information of an Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/account_put_contact_information/} for full documentation.
}
\keyword{internal}
