% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_cancel_key_deletion}
\alias{kms_cancel_key_deletion}
\title{Cancels the deletion of a KMS key}
\usage{
kms_cancel_key_deletion(KeyId)
}
\arguments{
\item{KeyId}{[required] Identifies the KMS key whose deletion is being canceled.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\description{
Cancels the deletion of a KMS key. When this operation succeeds, the key state of the KMS key is \code{Disabled}. To enable the KMS key, use \code{\link[=kms_enable_key]{enable_key}}.

See \url{https://paws-r.github.io/docs/kms/cancel_key_deletion.html} for full documentation.
}
\keyword{internal}
