% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_tag_saml_provider}
\alias{iam_tag_saml_provider}
\title{Adds one or more tags to a Security Assertion Markup Language (SAML)
identity provider}
\usage{
iam_tag_saml_provider(SAMLProviderArn, Tags)
}
\arguments{
\item{SAMLProviderArn}{[required] The ARN of the SAML identity provider in IAM to which you want to add
tags.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{[required] The list of tags that you want to attach to the SAML identity provider
in IAM. Each tag consists of a key name and an associated value.}
}
\description{
Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information about these providers, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based federation} . If a tag with the same key name already exists, then that tag is overwritten with the new value.

See \url{https://paws-r.github.io/docs/iam/tag_saml_provider.html} for full documentation.
}
\keyword{internal}
