% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_regex_match_set}
\alias{wafregional_delete_regex_match_set}
\title{This is AWS WAF CLASSIC documentation}
\usage{
wafregional_delete_regex_match_set(RegexMatchSetId, ChangeToken)
}
\arguments{
\item{RegexMatchSetId}{[required] The \code{RegexMatchSetId} of the RegexMatchSet that you want to delete.
\code{RegexMatchSetId} is returned by CreateRegexMatchSet and by
ListRegexMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a RegexMatchSet. You can\'t delete a \code{RegexMatchSet}
if it\'s still used in any \code{Rules} or if it still includes any
\code{RegexMatchTuples} objects (any filters).

If you just want to remove a \code{RegexMatchSet} from a \code{Rule}, use
UpdateRule.

To permanently delete a \code{RegexMatchSet}, perform the following steps:
\enumerate{
\item Update the \code{RegexMatchSet} to remove filters, if any. For more
information, see UpdateRegexMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteRegexMatchSet} request.
\item Submit a \code{DeleteRegexMatchSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_regex_match_set(
  RegexMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
