% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool}
\alias{cognitoidentityprovider_create_user_pool}
\title{Creates a new Amazon Cognito user pool and sets the password policy for
the pool}
\usage{
cognitoidentityprovider_create_user_pool(PoolName, Policies,
  LambdaConfig, AutoVerifiedAttributes, AliasAttributes,
  UsernameAttributes, SmsVerificationMessage, EmailVerificationMessage,
  EmailVerificationSubject, VerificationMessageTemplate,
  SmsAuthenticationMessage, MfaConfiguration, DeviceConfiguration,
  EmailConfiguration, SmsConfiguration, UserPoolTags,
  AdminCreateUserConfig, Schema, UserPoolAddOns)
}
\arguments{
\item{PoolName}{[required] A string used to name the user pool.}

\item{Policies}{The policies associated with the new user pool.}

\item{LambdaConfig}{The Lambda trigger configuration information for the new user pool.

In a push model, event sources (such as Amazon S3 and custom
applications) need permission to invoke a function. So you will need to
make an extra call to add permission for these event sources to invoke
your Lambda function.

For more information on using the Lambda API to add permission, see
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html}{AddPermission}
.

For adding permission using the AWS CLI, see
\href{https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html}{add-permission}
.}

\item{AutoVerifiedAttributes}{The attributes to be auto-verified. Possible values: \strong{email},
\strong{phone\_number}.}

\item{AliasAttributes}{Attributes supported as an alias for this user pool. Possible values:
\strong{phone\_number}, \strong{email}, or \strong{preferred\_username}.}

\item{UsernameAttributes}{Specifies whether email addresses or phone numbers can be specified as
usernames when a user signs up.}

\item{SmsVerificationMessage}{A string representing the SMS verification message.}

\item{EmailVerificationMessage}{A string representing the email verification message.}

\item{EmailVerificationSubject}{A string representing the email verification subject.}

\item{VerificationMessageTemplate}{The template for the verification message that the user sees when the
app requests permission to access the user's information.}

\item{SmsAuthenticationMessage}{A string representing the SMS authentication message.}

\item{MfaConfiguration}{Specifies MFA configuration details.}

\item{DeviceConfiguration}{The device configuration.}

\item{EmailConfiguration}{The email configuration.}

\item{SmsConfiguration}{The SMS configuration.}

\item{UserPoolTags}{The tag keys and values to assign to the user pool. A tag is a label
that you can use to categorize and manage user pools in different ways,
such as by purpose, owner, environment, or other criteria.}

\item{AdminCreateUserConfig}{The configuration for \code{AdminCreateUser} requests.}

\item{Schema}{An array of schema attributes for the new user pool. These attributes
can be standard or custom attributes.}

\item{UserPoolAddOns}{Used to enable advanced security risk detection. Set the key
\code{AdvancedSecurityMode} to the value "AUDIT".}
}
\description{
Creates a new Amazon Cognito user pool and sets the password policy for
the pool.
}
\section{Request syntax}{
\preformatted{svc$create_user_pool(
  PoolName = "string",
  Policies = list(
    PasswordPolicy = list(
      MinimumLength = 123,
      RequireUppercase = TRUE|FALSE,
      RequireLowercase = TRUE|FALSE,
      RequireNumbers = TRUE|FALSE,
      RequireSymbols = TRUE|FALSE,
      TemporaryPasswordValidityDays = 123
    )
  ),
  LambdaConfig = list(
    PreSignUp = "string",
    CustomMessage = "string",
    PostConfirmation = "string",
    PreAuthentication = "string",
    PostAuthentication = "string",
    DefineAuthChallenge = "string",
    CreateAuthChallenge = "string",
    VerifyAuthChallengeResponse = "string",
    PreTokenGeneration = "string",
    UserMigration = "string"
  ),
  AutoVerifiedAttributes = list(
    "phone_number"|"email"
  ),
  AliasAttributes = list(
    "phone_number"|"email"|"preferred_username"
  ),
  UsernameAttributes = list(
    "phone_number"|"email"
  ),
  SmsVerificationMessage = "string",
  EmailVerificationMessage = "string",
  EmailVerificationSubject = "string",
  VerificationMessageTemplate = list(
    SmsMessage = "string",
    EmailMessage = "string",
    EmailSubject = "string",
    EmailMessageByLink = "string",
    EmailSubjectByLink = "string",
    DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
  ),
  SmsAuthenticationMessage = "string",
  MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
  DeviceConfiguration = list(
    ChallengeRequiredOnNewDevice = TRUE|FALSE,
    DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
  ),
  EmailConfiguration = list(
    SourceArn = "string",
    ReplyToEmailAddress = "string",
    EmailSendingAccount = "COGNITO_DEFAULT"|"DEVELOPER"
  ),
  SmsConfiguration = list(
    SnsCallerArn = "string",
    ExternalId = "string"
  ),
  UserPoolTags = list(
    "string"
  ),
  AdminCreateUserConfig = list(
    AllowAdminCreateUserOnly = TRUE|FALSE,
    UnusedAccountValidityDays = 123,
    InviteMessageTemplate = list(
      SMSMessage = "string",
      EmailMessage = "string",
      EmailSubject = "string"
    )
  ),
  Schema = list(
    list(
      Name = "string",
      AttributeDataType = "String"|"Number"|"DateTime"|"Boolean",
      DeveloperOnlyAttribute = TRUE|FALSE,
      Mutable = TRUE|FALSE,
      Required = TRUE|FALSE,
      NumberAttributeConstraints = list(
        MinValue = "string",
        MaxValue = "string"
      ),
      StringAttributeConstraints = list(
        MinLength = "string",
        MaxLength = "string"
      )
    )
  ),
  UserPoolAddOns = list(
    AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
  )
)
}
}

\keyword{internal}
