% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_reset_user_password}
\alias{cognitoidentityprovider_admin_reset_user_password}
\title{Resets the specified user's password in a user pool as an administrator}
\usage{
cognitoidentityprovider_admin_reset_user_password(UserPoolId, Username)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to reset the user's
password.}

\item{Username}{[required] The user name of the user whose password you wish to reset.}
}
\description{
Resets the specified user's password in a user pool as an
administrator. Works on any user.
}
\details{
When a developer calls this API, the current password is invalidated, so
it must be changed. If a user tries to sign in after the API is called,
the app will get a PasswordResetRequiredException exception back and
should direct the user down the flow to reset the password, which is the
same as the forgot password flow. In addition, if the user pool has
phone verification selected and a verified phone number exists for the
user, or if email verification is selected and a verified email exists
for the user, calling this API will also result in sending a message to
the end user with the code to change their password.

Requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_reset_user_password(
  UserPoolId = "string",
  Username = "string"
)
}
}

\keyword{internal}
