% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_identity_provider}
\alias{cognitoidentityprovider_update_identity_provider}
\title{Updates identity provider information for a user pool}
\usage{
cognitoidentityprovider_update_identity_provider(UserPoolId,
  ProviderName, ProviderDetails, AttributeMapping, IdpIdentifiers)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ProviderName}{[required] The identity provider name.}

\item{ProviderDetails}{The identity provider details to be updated, such as \code{MetadataURL} and
\code{MetadataFile}.}

\item{AttributeMapping}{The identity provider attribute mapping to be changed.}

\item{IdpIdentifiers}{A list of identity provider identifiers.}
}
\description{
Updates identity provider information for a user pool.
}
\section{Request syntax}{
\preformatted{svc$update_identity_provider(
  UserPoolId = "string",
  ProviderName = "string",
  ProviderDetails = list(
    "string"
  ),
  AttributeMapping = list(
    "string"
  ),
  IdpIdentifiers = list(
    "string"
  )
)
}
}

\keyword{internal}
