% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_members}
\alias{guardduty_get_members}
\title{Retrieves GuardDuty member accounts (of the current GuardDuty
administrator account) specified by the account IDs}
\usage{
guardduty_get_members(DetectorId, AccountIds)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account whose members you
want to retrieve.}

\item{AccountIds}{[required] A list of account IDs of the GuardDuty member accounts that you want to
describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  Members = list(
    list(
      AccountId = "string",
      DetectorId = "string",
      MasterId = "string",
      Email = "string",
      RelationshipStatus = "string",
      InvitedAt = "string",
      UpdatedAt = "string"
    )
  ),
  UnprocessedAccounts = list(
    list(
      AccountId = "string",
      Result = "string"
    )
  )
)
}
}
\description{
Retrieves GuardDuty member accounts (of the current GuardDuty
administrator account) specified by the account IDs.
}
\section{Request syntax}{
\preformatted{svc$get_members(
  DetectorId = "string",
  AccountIds = list(
    "string"
  )
)
}
}

\keyword{internal}
