% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_random}
\alias{kms_generate_random}
\title{Returns a random byte string that is cryptographically secure}
\usage{
kms_generate_random(NumberOfBytes, CustomKeyStoreId)
}
\arguments{
\item{NumberOfBytes}{The length of the byte string.}

\item{CustomKeyStoreId}{Generates the random byte string in the AWS CloudHSM cluster that is
associated with the specified \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}.
To find the ID of a custom key store, use the
\code{\link[=kms_describe_custom_key_stores]{describe_custom_key_stores}}
operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  Plaintext = raw
)
}
}
\description{
Returns a random byte string that is cryptographically secure.

By default, the random byte string is generated in AWS KMS. To generate
the byte string in the AWS CloudHSM cluster that is associated with a
\href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store},
specify the custom key store ID.

For more information about entropy and random number generation, see the
AWS Key Management Service Cryptographic Details whitepaper.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:GenerateRandom}
(IAM policy)
}
\section{Request syntax}{
\preformatted{svc$generate_random(
  NumberOfBytes = 123,
  CustomKeyStoreId = "string"
)
}
}

\examples{
\dontrun{
# The following example uses AWS KMS to generate 32 bytes of random data.
svc$generate_random(
  NumberOfBytes = 32L
)
}

}
\keyword{internal}
