% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_random}
\alias{kms_generate_random}
\title{Returns a random byte string that is cryptographically secure}
\usage{
kms_generate_random(NumberOfBytes, CustomKeyStoreId)
}
\arguments{
\item{NumberOfBytes}{The length of the byte string.}

\item{CustomKeyStoreId}{Generates the random byte string in the AWS CloudHSM cluster that is
associated with the specified \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-store-overview.html}{custom key store}.
To find the ID of a custom key store, use the DescribeCustomKeyStores
operation.}
}
\description{
Returns a random byte string that is cryptographically secure.
}
\details{
By default, the random byte string is generated in AWS KMS. To generate
the byte string in the AWS CloudHSM cluster that is associated with a
\href{http://docs.aws.amazon.com/kms/latest/developerguide/key-store-overview.html}{custom key store},
specify the custom key store ID.

For more information about entropy and random number generation, see the
\href{https://d0.awsstatic.com/whitepapers/KMS-Cryptographic-Details.pdf}{AWS Key Management Service Cryptographic Details}
whitepaper.
}
\section{Request syntax}{
\preformatted{svc$generate_random(
  NumberOfBytes = 123,
  CustomKeyStoreId = "string"
)
}
}

\examples{
# The following example uses AWS KMS to generate 32 bytes of random data.
\donttest{svc$generate_random(
  NumberOfBytes = 32L
)}

}
\keyword{internal}
