% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_resync_mfa_device}
\alias{iam_resync_mfa_device}
\title{Synchronizes the specified MFA device with its IAM resource object on
the AWS servers}
\usage{
iam_resync_mfa_device(UserName, SerialNumber, AuthenticationCode1,
  AuthenticationCode2)
}
\arguments{
\item{UserName}{[required] The name of the user whose MFA device you want to resynchronize.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{SerialNumber}{[required] Serial number that uniquely identifies the MFA device.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{AuthenticationCode1}{[required] An authentication code emitted by the device.

The format for this parameter is a sequence of six digits.}

\item{AuthenticationCode2}{[required] A subsequent authentication code emitted by the device.

The format for this parameter is a sequence of six digits.}
}
\description{
Synchronizes the specified MFA device with its IAM resource object on
the AWS servers.
}
\details{
For more information about creating and working with virtual MFA
devices, go to \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html}{Using a Virtual MFA Device}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$resync_mfa_device(
  UserName = "string",
  SerialNumber = "string",
  AuthenticationCode1 = "string",
  AuthenticationCode2 = "string"
)
}
}

\keyword{internal}
