% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_user}
\alias{iam_create_user}
\title{Creates a new IAM user for your AWS account}
\usage{
iam_create_user(Path, UserName, PermissionsBoundary, Tags)
}
\arguments{
\item{Path}{The path for the user name. For more information about paths, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\code{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{UserName}{[required] The name of the user to create.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-.
User names are not distinguished by case. For example, you cannot create
users named both "TESTUSER" and "testuser".}

\item{PermissionsBoundary}{The ARN of the policy that is used to set the permissions boundary for
the user.}

\item{Tags}{A list of tags that you want to attach to the newly created user. Each
tag consists of a key name and an associated value. For more information
about tagging, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM Identities}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed number of
tags per user, then the entire request fails and the user is not
created.}
}
\description{
Creates a new IAM user for your AWS account.
}
\details{
For information about limitations on the number of IAM users you can
create, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html}{Limitations on IAM Entities}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  Path = "string",
  UserName = "string",
  PermissionsBoundary = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# The following create-user command creates an IAM user named Bob in the
# current account.
\donttest{svc$create_user(
  UserName = "Bob"
)}

}
\keyword{internal}
