% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_update_filter}
\alias{guardduty_update_filter}
\title{Updates the filter specified by the filter name}
\usage{
guardduty_update_filter(Action, Description, DetectorId, FilterName,
  FindingCriteria, Rank)
}
\arguments{
\item{Action}{Specifies the action that is to be applied to the findings that match the filter.}

\item{Description}{The description of the filter.}

\item{DetectorId}{[required] The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.}

\item{FilterName}{[required] The name of the filter.}

\item{FindingCriteria}{Represents the criteria to be used in the filter for querying findings.}

\item{Rank}{Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.}
}
\description{
Updates the filter specified by the filter name.
}
\section{Request syntax}{
\preformatted{svc$update_filter(
  Action = "NOOP"|"ARCHIVE",
  Description = "string",
  DetectorId = "string",
  FilterName = "string",
  FindingCriteria = list(
    Criterion = list(
      list(
        Eq = list(
          "string"
        ),
        Gt = 123,
        Gte = 123,
        Lt = 123,
        Lte = 123,
        Neq = list(
          "string"
        )
      )
    )
  ),
  Rank = 123
)
}
}

\keyword{internal}
