% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_rest_api}
\alias{apigateway_create_rest_api}
\title{Creates a new RestApi resource}
\usage{
apigateway_create_rest_api(name, description, version, cloneFrom,
  binaryMediaTypes, minimumCompressionSize, apiKeySource,
  endpointConfiguration, policy, tags)
}
\arguments{
\item{name}{[required] [Required] The name of the RestApi.}

\item{description}{The description of the RestApi.}

\item{version}{A version identifier for the API.}

\item{cloneFrom}{The ID of the RestApi that you want to clone from.}

\item{binaryMediaTypes}{The list of binary media types supported by the RestApi. By default, the
RestApi supports only UTF-8-encoded text payloads.}

\item{minimumCompressionSize}{A nullable integer that is used to enable compression (with non-negative
between 0 and 10485760 (10M) bytes, inclusive) or disable compression
(with a null value) on an API. When compression is enabled, compression
or decompression is not applied on the payload if the payload size is
smaller than this value. Setting it to zero allows compression for any
payload size.}

\item{apiKeySource}{The source of the API key for metering requests according to a usage
plan. Valid values are:
\itemize{
\item \code{HEADER} to read the API key from the \code{X-API-Key} header of a
request.
\item \code{AUTHORIZER} to read the API key from the \code{UsageIdentifierKey} from
a custom authorizer.
}}

\item{endpointConfiguration}{The endpoint configuration of this RestApi showing the endpoint types of
the API.}

\item{policy}{A stringified JSON policy document that applies to this RestApi regardless of the caller and <a>Method</a> configuration.}

\item{tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\_:/]. The tag key can be up to 128 characters and must not
start with \code{aws:}. The tag value can be up to 256 characters.}
}
\description{
Creates a new RestApi resource.
}
\section{Request syntax}{
\preformatted{svc$create_rest_api(
  name = "string",
  description = "string",
  version = "string",
  cloneFrom = "string",
  binaryMediaTypes = list(
    "string"
  ),
  minimumCompressionSize = 123,
  apiKeySource = "HEADER"|"AUTHORIZER",
  endpointConfiguration = list(
    types = list(
      "REGIONAL"|"EDGE"|"PRIVATE"
    )
  ),
  policy = "string",
  tags = list(
    "string"
  )
)
}
}

\keyword{internal}
