% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_direct_connect_gateway_associations}
\alias{directconnect_describe_direct_connect_gateway_associations}
\title{Lists the associations between your Direct Connect gateways and virtual
private gateways}
\usage{
directconnect_describe_direct_connect_gateway_associations(
  associationId, associatedGatewayId, directConnectGatewayId, maxResults,
  nextToken, virtualGatewayId)
}
\arguments{
\item{associationId}{The ID of the Direct Connect gateway association.}

\item{associatedGatewayId}{The ID of the associated gateway.}

\item{directConnectGatewayId}{The ID of the Direct Connect gateway.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.

If \code{MaxResults} is given a value larger than 100, only 100 results are
returned.}

\item{nextToken}{The token provided in the previous call to retrieve the next page.}

\item{virtualGatewayId}{The ID of the virtual private gateway.}
}
\value{
A list with the following syntax:\preformatted{list(
  directConnectGatewayAssociations = list(
    list(
      directConnectGatewayId = "string",
      directConnectGatewayOwnerAccount = "string",
      associationState = "associating"|"associated"|"disassociating"|"disassociated"|"updating",
      stateChangeError = "string",
      associatedGateway = list(
        id = "string",
        type = "virtualPrivateGateway"|"transitGateway",
        ownerAccount = "string",
        region = "string"
      ),
      associationId = "string",
      allowedPrefixesToDirectConnectGateway = list(
        list(
          cidr = "string"
        )
      ),
      virtualGatewayId = "string",
      virtualGatewayRegion = "string",
      virtualGatewayOwnerAccount = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists the associations between your Direct Connect gateways and virtual
private gateways. You must specify a Direct Connect gateway, a virtual
private gateway, or both. If you specify a Direct Connect gateway, the
response contains all virtual private gateways associated with the
Direct Connect gateway. If you specify a virtual private gateway, the
response contains all Direct Connect gateways associated with the
virtual private gateway. If you specify both, the response contains the
association between the Direct Connect gateway and the virtual private
gateway.
}
\section{Request syntax}{
\preformatted{svc$describe_direct_connect_gateway_associations(
  associationId = "string",
  associatedGatewayId = "string",
  directConnectGatewayId = "string",
  maxResults = 123,
  nextToken = "string",
  virtualGatewayId = "string"
)
}
}

\keyword{internal}
