% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_reimport_api}
\alias{apigatewayv2_reimport_api}
\title{Puts an Api resource}
\usage{
apigatewayv2_reimport_api(ApiId, Basepath, Body, FailOnWarnings)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{Basepath}{Specifies how to interpret the base path of the API during import. Valid
values are ignore, prepend, and split. The default value is ignore. To
learn more, see \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api-basePath.html}{Set the OpenAPI basePath Property}.
Supported only for HTTP APIs.}

\item{Body}{[required] The OpenAPI definition. Supported only for HTTP APIs.}

\item{FailOnWarnings}{Specifies whether to rollback the API creation when a warning is
encountered. By default, API creation continues if a warning is
encountered.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApiEndpoint = "string",
  ApiGatewayManaged = TRUE|FALSE,
  ApiId = "string",
  ApiKeySelectionExpression = "string",
  CorsConfiguration = list(
    AllowCredentials = TRUE|FALSE,
    AllowHeaders = list(
      "string"
    ),
    AllowMethods = list(
      "string"
    ),
    AllowOrigins = list(
      "string"
    ),
    ExposeHeaders = list(
      "string"
    ),
    MaxAge = 123
  ),
  CreatedDate = as.POSIXct(
    "2015-01-01"
  ),
  Description = "string",
  DisableSchemaValidation = TRUE|FALSE,
  DisableExecuteApiEndpoint = TRUE|FALSE,
  ImportInfo = list(
    "string"
  ),
  Name = "string",
  ProtocolType = "WEBSOCKET"|"HTTP",
  RouteSelectionExpression = "string",
  Tags = list(
    "string"
  ),
  Version = "string",
  Warnings = list(
    "string"
  )
)
}
}
\description{
Puts an Api resource.
}
\section{Request syntax}{
\preformatted{svc$reimport_api(
  ApiId = "string",
  Basepath = "string",
  Body = "string",
  FailOnWarnings = TRUE|FALSE
)
}
}

\keyword{internal}
