% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_get_stages}
\alias{apigatewayv2_get_stages}
\title{Gets the Stages for an API}
\usage{
apigatewayv2_get_stages(ApiId, MaxResults, NextToken)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{MaxResults}{The maximum number of elements to be returned for this resource.}

\item{NextToken}{The next page of elements from this collection. Not valid for the last
element of the collection.}
}
\value{
A list with the following syntax:\preformatted{list(
  Items = list(
    list(
      AccessLogSettings = list(
        DestinationArn = "string",
        Format = "string"
      ),
      ApiGatewayManaged = TRUE|FALSE,
      AutoDeploy = TRUE|FALSE,
      ClientCertificateId = "string",
      CreatedDate = as.POSIXct(
        "2015-01-01"
      ),
      DefaultRouteSettings = list(
        DataTraceEnabled = TRUE|FALSE,
        DetailedMetricsEnabled = TRUE|FALSE,
        LoggingLevel = "ERROR"|"INFO"|"OFF",
        ThrottlingBurstLimit = 123,
        ThrottlingRateLimit = 123.0
      ),
      DeploymentId = "string",
      Description = "string",
      LastDeploymentStatusMessage = "string",
      LastUpdatedDate = as.POSIXct(
        "2015-01-01"
      ),
      RouteSettings = list(
        list(
          DataTraceEnabled = TRUE|FALSE,
          DetailedMetricsEnabled = TRUE|FALSE,
          LoggingLevel = "ERROR"|"INFO"|"OFF",
          ThrottlingBurstLimit = 123,
          ThrottlingRateLimit = 123.0
        )
      ),
      StageName = "string",
      StageVariables = list(
        "string"
      ),
      Tags = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets the Stages for an API.
}
\section{Request syntax}{
\preformatted{svc$get_stages(
  ApiId = "string",
  MaxResults = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
