% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_describe_provisioning_parameters}
\alias{servicecatalog_describe_provisioning_parameters}
\title{Gets information about the configuration required to provision the
specified product using the specified provisioning artifact}
\usage{
servicecatalog_describe_provisioning_parameters(
  AcceptLanguage = NULL,
  ProductId = NULL,
  ProductName = NULL,
  ProvisioningArtifactId = NULL,
  ProvisioningArtifactName = NULL,
  PathId = NULL,
  PathName = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{The product identifier. You must provide the product name or ID, but not
both.}

\item{ProductName}{The name of the product. You must provide the name or ID, but not both.}

\item{ProvisioningArtifactId}{The identifier of the provisioning artifact. You must provide the name
or ID, but not both.}

\item{ProvisioningArtifactName}{The name of the provisioning artifact. You must provide the name or ID,
but not both.}

\item{PathId}{The path identifier of the product. This value is optional if the
product has a default path, and required if the product has more than
one path. To list the paths for a product, use
\code{\link[=servicecatalog_list_launch_paths]{list_launch_paths}}. You must
provide the name or ID, but not both.}

\item{PathName}{The name of the path. You must provide the name or ID, but not both.}
}
\description{
Gets information about the configuration required to provision the specified product using the specified provisioning artifact.

See \url{https://www.paws-r-sdk.com/docs/servicecatalog_describe_provisioning_parameters/} for full documentation.
}
\keyword{internal}
