% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_move_account}
\alias{organizations_move_account}
\title{Moves an account from its current source parent root or organizational
unit (OU) to the specified destination parent root or OU}
\usage{
organizations_move_account(AccountId, SourceParentId, DestinationParentId)
}
\arguments{
\item{AccountId}{[required] The unique identifier (ID) of the account that you want to move.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for an account
ID string requires exactly 12 digits.}

\item{SourceParentId}{[required] The unique identifier (ID) of the root or organizational unit that you
want to move the account from.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a parent ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with "r-" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Organizational unit (OU)} - A string that begins with "ou-"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second "-"
dash and from 8 to 32 additional lowercase letters or digits.
}}

\item{DestinationParentId}{[required] The unique identifier (ID) of the root or organizational unit that you
want to move the account to.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a parent ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with "r-" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Organizational unit (OU)} - A string that begins with "ou-"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second "-"
dash and from 8 to 32 additional lowercase letters or digits.
}}
}
\description{
Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU.

See \url{https://www.paws-r-sdk.com/docs/organizations_move_account/} for full documentation.
}
\keyword{internal}
