% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_update_feature}
\alias{cloudwatchevidently_update_feature}
\title{Updates an existing feature}
\usage{
cloudwatchevidently_update_feature(
  addOrUpdateVariations = NULL,
  defaultVariation = NULL,
  description = NULL,
  entityOverrides = NULL,
  evaluationStrategy = NULL,
  feature,
  project,
  removeVariations = NULL
)
}
\arguments{
\item{addOrUpdateVariations}{To update variation configurations for this feature, or add new ones,
specify this structure. In this array, include any variations that you
want to add or update. If the array includes a variation name that
already exists for this feature, it is updated. If it includes a new
variation name, it is added as a new variation.}

\item{defaultVariation}{The name of the variation to use as the default variation. The default
variation is served to users who are not allocated to any ongoing
launches or experiments of this feature.}

\item{description}{An optional description of the feature.}

\item{entityOverrides}{Specified users that should always be served a specific variation of a
feature. Each user is specified by a key-value pair . For each key,
specify a user by entering their user ID, account ID, or some other
identifier. For the value, specify the name of the variation that they
are to be served.

This parameter is limited to 2500 overrides or a total of 40KB. The 40KB
limit includes an overhead of 6 bytes per override.}

\item{evaluationStrategy}{Specify \code{ALL_RULES} to activate the traffic allocation specified by any
ongoing launches or experiments. Specify \code{DEFAULT_VARIATION} to serve
the default variation to all users instead.}

\item{feature}{[required] The name of the feature to be updated.}

\item{project}{[required] The name or ARN of the project that contains the feature to be updated.}

\item{removeVariations}{Removes a variation from the feature. If the variation you specify
doesn't exist, then this makes no change and does not report an error.

This operation fails if you try to remove a variation that is part of an
ongoing launch or experiment.}
}
\description{
Updates an existing feature.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_feature/} for full documentation.
}
\keyword{internal}
