% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_get_metric_data}
\alias{cloudwatch_get_metric_data}
\title{You can use the GetMetricData API to retrieve CloudWatch metric values}
\usage{
cloudwatch_get_metric_data(
  MetricDataQueries,
  StartTime,
  EndTime,
  NextToken = NULL,
  ScanBy = NULL,
  MaxDatapoints = NULL,
  LabelOptions = NULL
)
}
\arguments{
\item{MetricDataQueries}{[required] The metric queries to be returned. A single
\code{\link[=cloudwatch_get_metric_data]{get_metric_data}} call can include as many
as 500 \code{MetricDataQuery} structures. Each of these structures can
specify either a metric to retrieve, a Metrics Insights query, or a math
expression to perform on retrieved data.}

\item{StartTime}{[required] The time stamp indicating the earliest data to be returned.

The value specified is inclusive; results include data points with the
specified time stamp.

CloudWatch rounds the specified time stamp as follows:
\itemize{
\item Start time less than 15 days ago - Round down to the nearest whole
minute. For example, 12:32:34 is rounded down to 12:32:00.
\item Start time between 15 and 63 days ago - Round down to the nearest
5-minute clock interval. For example, 12:32:34 is rounded down to
12:30:00.
\item Start time greater than 63 days ago - Round down to the nearest
1-hour clock interval. For example, 12:32:34 is rounded down to
12:00:00.
}

If you set \code{Period} to 5, 10, or 30, the start time of your request is
rounded down to the nearest time that corresponds to even 5-, 10-, or
30-second divisions of a minute. For example, if you make a query at
(HH:mm:ss) 01:05:23 for the previous 10-second period, the start time of
your request is rounded down and you receive data from 01:05:10 to
01:05:20. If you make a query at 15:07:17 for the previous 5 minutes of
data, using a period of 5 seconds, you receive data timestamped between
15:02:15 and 15:07:15.

For better performance, specify \code{StartTime} and \code{EndTime} values that
align with the value of the metric's \code{Period} and sync up with the
beginning and end of an hour. For example, if the \code{Period} of a metric
is 5 minutes, specifying 12:05 or 12:30 as \code{StartTime} can get a faster
response from CloudWatch than setting 12:07 or 12:29 as the \code{StartTime}.}

\item{EndTime}{[required] The time stamp indicating the latest data to be returned.

The value specified is exclusive; results include data points up to the
specified time stamp.

For better performance, specify \code{StartTime} and \code{EndTime} values that
align with the value of the metric's \code{Period} and sync up with the
beginning and end of an hour. For example, if the \code{Period} of a metric
is 5 minutes, specifying 12:05 or 12:30 as \code{EndTime} can get a faster
response from CloudWatch than setting 12:07 or 12:29 as the \code{EndTime}.}

\item{NextToken}{Include this value, if it was returned by the previous
\code{\link[=cloudwatch_get_metric_data]{get_metric_data}} operation, to get the
next set of data points.}

\item{ScanBy}{The order in which data points should be returned. \code{TimestampDescending}
returns the newest data first and paginates when the \code{MaxDatapoints}
limit is reached. \code{TimestampAscending} returns the oldest data first and
paginates when the \code{MaxDatapoints} limit is reached.}

\item{MaxDatapoints}{The maximum number of data points the request should return before
paginating. If you omit this, the default of 100,800 is used.}

\item{LabelOptions}{This structure includes the \code{Timezone} parameter, which you can use to
specify your time zone so that the labels of returned data display the
correct time for your time zone.}
}
\description{
You can use the \code{\link[=cloudwatch_get_metric_data]{get_metric_data}} API to retrieve CloudWatch metric values. The operation can also include a CloudWatch Metrics Insights query, and one or more metric math functions.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_get_metric_data/} for full documentation.
}
\keyword{internal}
