% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_app_input_sources}
\alias{resiliencehub_list_app_input_sources}
\title{Lists all the input sources of the Resilience Hub application}
\usage{
resiliencehub_list_app_input_sources(
  appArn,
  appVersion,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{appVersion}{[required] Resilience Hub application version.}

\item{maxResults}{Maximum number of input sources to be displayed per Resilience Hub
application.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}
}
\description{
Lists all the input sources of the Resilience Hub application. For more information about the input sources supported by Resilience Hub, see \href{https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html}{Discover the structure and describe your Resilience Hub application}.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_app_input_sources/} for full documentation.
}
\keyword{internal}
