% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmcontacts_operations.R
\name{ssmcontacts_create_contact}
\alias{ssmcontacts_create_contact}
\title{Contacts are either the contacts that Incident Manager engages during an
incident or the escalation plans that Incident Manager uses to engage
contacts in phases during an incident}
\usage{
ssmcontacts_create_contact(
  Alias,
  DisplayName = NULL,
  Type,
  Plan,
  Tags = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{Alias}{[required] The short name to quickly identify a contact or escalation plan. The
contact alias must be unique and identifiable.}

\item{DisplayName}{The full name of the contact or escalation plan.}

\item{Type}{[required] To create an escalation plan use \code{ESCALATION}. To create a contact use
\code{PERSONAL}.}

\item{Plan}{[required] A list of stages. A contact has an engagement plan with stages that
contact specified contact channels. An escalation plan uses stages that
contact specified contacts.}

\item{Tags}{Adds a tag to the target. You can only tag resources created in the
first Region of your replication set.}

\item{IdempotencyToken}{A token ensuring that the operation is called only once with the
specified details.}
}
\description{
Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.

See \url{https://paws-r.github.io/docs/ssmcontacts/create_contact.html} for full documentation.
}
\keyword{internal}
