# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS OpsWorks CM
#'
#' @description
#' AWS OpsWorks for configuration management (CM) is a service that runs
#' and manages configuration management servers. You can use AWS OpsWorks
#' CM to create and manage AWS OpsWorks for Chef Automate and AWS OpsWorks
#' for Puppet Enterprise servers, and add or remove nodes for the servers
#' to manage.
#' 
#' **Glossary of terms**
#' 
#' -   **Server**: A configuration management server that can be
#'     highly-available. The configuration management server runs on an
#'     Amazon Elastic Compute Cloud (EC2) instance, and may use various
#'     other AWS services, such as Amazon Relational Database Service (RDS)
#'     and Elastic Load Balancing. A server is a generic abstraction over
#'     the configuration manager that you want to use, much like Amazon
#'     RDS. In AWS OpsWorks CM, you do not start or stop servers. After you
#'     create servers, they continue to run until they are deleted.
#' 
#' -   **Engine**: The engine is the specific configuration manager that
#'     you want to use. Valid values in this release include `ChefAutomate`
#'     and `Puppet`.
#' 
#' -   **Backup**: This is an application-level backup of the data that the
#'     configuration manager stores. AWS OpsWorks CM creates an S3 bucket
#'     for backups when you launch the first server. A backup maintains a
#'     snapshot of a server\'s configuration-related attributes at the time
#'     the backup starts.
#' 
#' -   **Events**: Events are always related to a server. Events are
#'     written during server creation, when health checks run, when backups
#'     are created, when system maintenance is performed, etc. When you
#'     delete a server, the server\'s events are also deleted.
#' 
#' -   **Account attributes**: Every account has attributes that are
#'     assigned in the AWS OpsWorks CM database. These attributes store
#'     information about configuration limits (servers, backups, etc.) and
#'     your customer account.
#' 
#' **Endpoints**
#' 
#' AWS OpsWorks CM supports the following endpoints, all HTTPS. You must
#' connect to one of the following endpoints. Your servers can only be
#' accessed or managed within the endpoint in which they are created.
#' 
#' -   opsworks-cm.us-east-1.amazonaws.com
#' 
#' -   opsworks-cm.us-east-2.amazonaws.com
#' 
#' -   opsworks-cm.us-west-1.amazonaws.com
#' 
#' -   opsworks-cm.us-west-2.amazonaws.com
#' 
#' -   opsworks-cm.ap-northeast-1.amazonaws.com
#' 
#' -   opsworks-cm.ap-southeast-1.amazonaws.com
#' 
#' -   opsworks-cm.ap-southeast-2.amazonaws.com
#' 
#' -   opsworks-cm.eu-central-1.amazonaws.com
#' 
#' -   opsworks-cm.eu-west-1.amazonaws.com
#' 
#' **Throttling limits**
#' 
#' All API operations allow for five requests per second with a burst of 10
#' requests per second.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- opsworkscm(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{svc <- opsworkscm()
#' svc$associate_node(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=opsworkscm_associate_node]{associate_node} \tab Associates a new node with the server \cr
#'  \link[=opsworkscm_create_backup]{create_backup} \tab Creates an application-level backup of a server \cr
#'  \link[=opsworkscm_create_server]{create_server} \tab Creates and immedately starts a new server \cr
#'  \link[=opsworkscm_delete_backup]{delete_backup} \tab Deletes a backup \cr
#'  \link[=opsworkscm_delete_server]{delete_server} \tab Deletes the server and the underlying AWS CloudFormation stacks (including the server's EC2 instance) \cr
#'  \link[=opsworkscm_describe_account_attributes]{describe_account_attributes} \tab Describes your OpsWorks-CM account attributes \cr
#'  \link[=opsworkscm_describe_backups]{describe_backups} \tab Describes backups \cr
#'  \link[=opsworkscm_describe_events]{describe_events} \tab Describes events for a specified server \cr
#'  \link[=opsworkscm_describe_node_association_status]{describe_node_association_status} \tab Returns the current status of an existing association or disassociation request \cr
#'  \link[=opsworkscm_describe_servers]{describe_servers} \tab Lists all configuration management servers that are identified with your account \cr
#'  \link[=opsworkscm_disassociate_node]{disassociate_node} \tab Disassociates a node from an AWS OpsWorks CM server, and removes the node from the server's managed nodes \cr
#'  \link[=opsworkscm_export_server_engine_attribute]{export_server_engine_attribute} \tab Exports a specified server engine attribute as a base64-encoded string \cr
#'  \link[=opsworkscm_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups\cr
#'  \link[=opsworkscm_restore_server]{restore_server} \tab Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY, RUNNING, UNHEALTHY, or TERMINATED state \cr
#'  \link[=opsworkscm_start_maintenance]{start_maintenance} \tab Manually starts server maintenance \cr
#'  \link[=opsworkscm_tag_resource]{tag_resource} \tab Applies tags to an AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise server, or to server backups \cr
#'  \link[=opsworkscm_untag_resource]{untag_resource} \tab Removes specified tags from an AWS OpsWorks-CM server or backup \cr
#'  \link[=opsworkscm_update_server]{update_server} \tab Updates settings for a server \cr
#'  \link[=opsworkscm_update_server_engine_attributes]{update_server_engine_attributes} \tab Updates engine-specific attributes on a specified server 
#' }
#'
#' @rdname opsworkscm
#' @export
opsworkscm <- function(config = list()) {
  svc <- .opsworkscm$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.opsworkscm <- list()

.opsworkscm$operations <- list()

.opsworkscm$metadata <- list(
  service_name = "opsworks-cm",
  endpoints = list("*" = list(endpoint = "opsworks-cm.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "opsworks-cm.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "OpsWorksCM",
  api_version = "2016-11-01",
  signing_name = "opsworks-cm",
  json_version = "1.1",
  target_prefix = "OpsWorksCM_V2016_11_01"
)

.opsworkscm$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.opsworkscm$metadata, handlers, config)
}
