% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_maintenance_window_tasks}
\alias{ssm_describe_maintenance_window_tasks}
\title{Lists the tasks in a maintenance window}
\usage{
ssm_describe_maintenance_window_tasks(WindowId, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{WindowId}{[required] The ID of the maintenance window whose tasks should be retrieved.}

\item{Filters}{Optional filters used to narrow down the scope of the returned tasks.
The supported filter keys are WindowTaskId, TaskArn, Priority, and
TaskType.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Lists the tasks in a maintenance window.
}
\section{Request syntax}{
\preformatted{svc$describe_maintenance_window_tasks(
  WindowId = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
