% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicequotas_operations.R
\name{servicequotas_list_service_quotas}
\alias{servicequotas_list_service_quotas}
\title{Lists all service quotas for the specified AWS service}
\usage{
servicequotas_list_service_quotas(ServiceCode, NextToken, MaxResults)
}
\arguments{
\item{ServiceCode}{[required] The identifier for a service. When performing an operation, use the
\code{ServiceCode} to specify a particular service.}

\item{NextToken}{(Optional) Use this parameter in a request if you receive a \code{NextToken}
response in a previous request that indicates that there's more output
available. In a subsequent call, set it to the value of the previous
call's \code{NextToken} response to indicate where the output should
continue from.}

\item{MaxResults}{(Optional) Limits the number of results that you want to include in the
response. If you don't include this parameter, the response defaults to
a value that's specific to the operation. If additional items exist
beyond the specified maximum, the \code{NextToken} element is present and has
a value (isn't null). Include that value as the \code{NextToken} request
parameter in the call to the operation to get the next part of the
results. You should check \code{NextToken} after every operation to ensure
that you receive all of the results.}
}
\description{
Lists all service quotas for the specified AWS service. This request
returns a list of the service quotas for the specified service. you'll
see the default values are the values that AWS provides for the quotas.
}
\details{
Always check the \code{NextToken} response parameter when calling any of the
\code{List*} operations. These operations can return an unexpected list of
results, even when there are more results available. When this happens,
the \code{NextToken} response parameter contains a value to pass the next
call to the same API to request the next part of the list.
}
\section{Request syntax}{
\preformatted{svc$list_service_quotas(
  ServiceCode = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
