% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_signal_resource}
\alias{cloudformation_signal_resource}
\title{Sends a signal to the specified resource with a success or failure
status}
\usage{
cloudformation_signal_resource(StackName, LogicalResourceId, UniqueId,
  Status)
}
\arguments{
\item{StackName}{[required] The stack name or unique stack ID that includes the resource that you
want to signal.}

\item{LogicalResourceId}{[required] The logical ID of the resource that you want to signal. The logical ID
is the name of the resource that given in the template.}

\item{UniqueId}{[required] A unique ID of the signal. When you signal Amazon EC2 instances or Auto
Scaling groups, specify the instance ID that you are signaling as the
unique ID. If you send multiple signals to a single resource (such as
signaling a wait condition), each signal requires a different unique ID.}

\item{Status}{[required] The status of the signal, which is either success or failure. A failure
signal causes AWS CloudFormation to immediately fail the stack creation
or update.}
}
\description{
Sends a signal to the specified resource with a success or failure
status. You can use the SignalResource API in conjunction with a
creation policy or update policy. AWS CloudFormation doesn't proceed
with a stack creation or update until resources receive the required
number of signals or the timeout period is exceeded. The SignalResource
API is useful in cases where you want to send signals from anywhere
other than an Amazon EC2 instance.
}
\section{Request syntax}{
\preformatted{svc$signal_resource(
  StackName = "string",
  LogicalResourceId = "string",
  UniqueId = "string",
  Status = "SUCCESS"|"FAILURE"
)
}
}

\keyword{internal}
