# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchlogs_service.R
NULL

#' Associates the specified AWS Key Management Service (AWS KMS) customer
#' master key (CMK) with the specified log group
#'
#' Associates the specified AWS Key Management Service (AWS KMS) customer
#' master key (CMK) with the specified log group.
#' 
#' Associating an AWS KMS CMK with a log group overrides any existing
#' associations between the log group and a CMK. After a CMK is associated
#' with a log group, all newly ingested data for the log group is encrypted
#' using the CMK. This association is stored as long as the data encrypted
#' with the CMK is still within Amazon CloudWatch Logs. This enables Amazon
#' CloudWatch Logs to decrypt this data whenever it is requested.
#' 
#' Note that it can take up to 5 minutes for this operation to take effect.
#' 
#' If you attempt to associate a CMK with a log group but the CMK does not
#' exist or the CMK is disabled, you will receive an
#' `InvalidParameterException` error.
#'
#' @usage
#' cloudwatchlogs_associate_kms_key(logGroupName, kmsKeyId)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param kmsKeyId &#91;required&#93; The Amazon Resource Name (ARN) of the CMK to use when encrypting log
#' data. For more information, see [Amazon Resource Names - AWS Key
#' Management Service (AWS
#' KMS)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
#'
#' @section Request syntax:
#' ```
#' svc$associate_kms_key(
#'   logGroupName = "string",
#'   kmsKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_associate_kms_key
cloudwatchlogs_associate_kms_key <- function(logGroupName, kmsKeyId) {
  op <- new_operation(
    name = "AssociateKmsKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$associate_kms_key_input(logGroupName = logGroupName, kmsKeyId = kmsKeyId)
  output <- .cloudwatchlogs$associate_kms_key_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$associate_kms_key <- cloudwatchlogs_associate_kms_key

#' Cancels the specified export task
#'
#' Cancels the specified export task.
#' 
#' The task must be in the `PENDING` or `RUNNING` state.
#'
#' @usage
#' cloudwatchlogs_cancel_export_task(taskId)
#'
#' @param taskId &#91;required&#93; The ID of the export task.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_export_task(
#'   taskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_cancel_export_task
cloudwatchlogs_cancel_export_task <- function(taskId) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$cancel_export_task_input(taskId = taskId)
  output <- .cloudwatchlogs$cancel_export_task_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$cancel_export_task <- cloudwatchlogs_cancel_export_task

#' Creates an export task, which allows you to efficiently export data from
#' a log group to an Amazon S3 bucket
#'
#' Creates an export task, which allows you to efficiently export data from
#' a log group to an Amazon S3 bucket.
#' 
#' This is an asynchronous call. If all the required information is
#' provided, this operation initiates an export task and responds with the
#' ID of the task. After the task has started, you can use
#' DescribeExportTasks to get the status of the export task. Each account
#' can only have one active (`RUNNING` or `PENDING`) export task at a time.
#' To cancel an export task, use CancelExportTask.
#' 
#' You can export logs from multiple log groups or multiple time ranges to
#' the same S3 bucket. To separate out log data for each export task, you
#' can specify a prefix to be used as the Amazon S3 key prefix for all
#' exported objects.
#'
#' @usage
#' cloudwatchlogs_create_export_task(taskName, logGroupName,
#'   logStreamNamePrefix, from, to, destination, destinationPrefix)
#'
#' @param taskName The name of the export task.
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamNamePrefix Export only log streams that match the provided prefix. If you don\'t
#' specify a value, no prefix filter is applied.
#' @param from &#91;required&#93; The start time of the range for the request, expressed as the number of
#' milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
#' earlier than this time are not exported.
#' @param to &#91;required&#93; The end time of the range for the request, expressed as the number of
#' milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
#' later than this time are not exported.
#' @param destination &#91;required&#93; The name of S3 bucket for the exported log data. The bucket must be in
#' the same AWS region.
#' @param destinationPrefix The prefix used as the start of the key for every object exported. If
#' you don\'t specify a value, the default is `exportedlogs`.
#'
#' @section Request syntax:
#' ```
#' svc$create_export_task(
#'   taskName = "string",
#'   logGroupName = "string",
#'   logStreamNamePrefix = "string",
#'   from = 123,
#'   to = 123,
#'   destination = "string",
#'   destinationPrefix = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_export_task
cloudwatchlogs_create_export_task <- function(taskName = NULL, logGroupName, logStreamNamePrefix = NULL, from, to, destination, destinationPrefix = NULL) {
  op <- new_operation(
    name = "CreateExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_export_task_input(taskName = taskName, logGroupName = logGroupName, logStreamNamePrefix = logStreamNamePrefix, from = from, to = to, destination = destination, destinationPrefix = destinationPrefix)
  output <- .cloudwatchlogs$create_export_task_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_export_task <- cloudwatchlogs_create_export_task

#' Creates a log group with the specified name
#'
#' Creates a log group with the specified name.
#' 
#' You can create up to 5000 log groups per account.
#' 
#' You must use the following guidelines when naming a log group:
#' 
#' -   Log group names must be unique within a region for an AWS account.
#' 
#' -   Log group names can be between 1 and 512 characters long.
#' 
#' -   Log group names consist of the following characters: a-z, A-Z, 0-9,
#'     \'\\_\' (underscore), \'-\' (hyphen), \'/\' (forward slash), and
#'     \'.\' (period).
#' 
#' If you associate a AWS Key Management Service (AWS KMS) customer master
#' key (CMK) with the log group, ingested data is encrypted using the CMK.
#' This association is stored as long as the data encrypted with the CMK is
#' still within Amazon CloudWatch Logs. This enables Amazon CloudWatch Logs
#' to decrypt this data whenever it is requested.
#' 
#' If you attempt to associate a CMK with the log group but the CMK does
#' not exist or the CMK is disabled, you will receive an
#' `InvalidParameterException` error.
#'
#' @usage
#' cloudwatchlogs_create_log_group(logGroupName, kmsKeyId, tags)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param kmsKeyId The Amazon Resource Name (ARN) of the CMK to use when encrypting log
#' data. For more information, see [Amazon Resource Names - AWS Key
#' Management Service (AWS
#' KMS)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms).
#' @param tags The key-value pairs to use for the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_log_group(
#'   logGroupName = "string",
#'   kmsKeyId = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_log_group
cloudwatchlogs_create_log_group <- function(logGroupName, kmsKeyId = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_log_group_input(logGroupName = logGroupName, kmsKeyId = kmsKeyId, tags = tags)
  output <- .cloudwatchlogs$create_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_log_group <- cloudwatchlogs_create_log_group

#' Creates a log stream for the specified log group
#'
#' Creates a log stream for the specified log group.
#' 
#' There is no limit on the number of log streams that you can create for a
#' log group.
#' 
#' You must use the following guidelines when naming a log stream:
#' 
#' -   Log stream names must be unique within the log group.
#' 
#' -   Log stream names can be between 1 and 512 characters long.
#' 
#' -   The \':\' (colon) and \'\*\' (asterisk) characters are not allowed.
#'
#' @usage
#' cloudwatchlogs_create_log_stream(logGroupName, logStreamName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#'
#' @section Request syntax:
#' ```
#' svc$create_log_stream(
#'   logGroupName = "string",
#'   logStreamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_create_log_stream
cloudwatchlogs_create_log_stream <- function(logGroupName, logStreamName) {
  op <- new_operation(
    name = "CreateLogStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$create_log_stream_input(logGroupName = logGroupName, logStreamName = logStreamName)
  output <- .cloudwatchlogs$create_log_stream_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$create_log_stream <- cloudwatchlogs_create_log_stream

#' Deletes the specified destination, and eventually disables all the
#' subscription filters that publish to it
#'
#' Deletes the specified destination, and eventually disables all the
#' subscription filters that publish to it. This operation does not delete
#' the physical resource encapsulated by the destination.
#'
#' @usage
#' cloudwatchlogs_delete_destination(destinationName)
#'
#' @param destinationName &#91;required&#93; The name of the destination.
#'
#' @section Request syntax:
#' ```
#' svc$delete_destination(
#'   destinationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_destination
cloudwatchlogs_delete_destination <- function(destinationName) {
  op <- new_operation(
    name = "DeleteDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_destination_input(destinationName = destinationName)
  output <- .cloudwatchlogs$delete_destination_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_destination <- cloudwatchlogs_delete_destination

#' Deletes the specified log group and permanently deletes all the archived
#' log events associated with the log group
#'
#' Deletes the specified log group and permanently deletes all the archived
#' log events associated with the log group.
#'
#' @usage
#' cloudwatchlogs_delete_log_group(logGroupName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_log_group(
#'   logGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_log_group
cloudwatchlogs_delete_log_group <- function(logGroupName) {
  op <- new_operation(
    name = "DeleteLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_log_group_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$delete_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_log_group <- cloudwatchlogs_delete_log_group

#' Deletes the specified log stream and permanently deletes all the
#' archived log events associated with the log stream
#'
#' Deletes the specified log stream and permanently deletes all the
#' archived log events associated with the log stream.
#'
#' @usage
#' cloudwatchlogs_delete_log_stream(logGroupName, logStreamName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#'
#' @section Request syntax:
#' ```
#' svc$delete_log_stream(
#'   logGroupName = "string",
#'   logStreamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_log_stream
cloudwatchlogs_delete_log_stream <- function(logGroupName, logStreamName) {
  op <- new_operation(
    name = "DeleteLogStream",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_log_stream_input(logGroupName = logGroupName, logStreamName = logStreamName)
  output <- .cloudwatchlogs$delete_log_stream_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_log_stream <- cloudwatchlogs_delete_log_stream

#' Deletes the specified metric filter
#'
#' Deletes the specified metric filter.
#'
#' @usage
#' cloudwatchlogs_delete_metric_filter(logGroupName, filterName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; The name of the metric filter.
#'
#' @section Request syntax:
#' ```
#' svc$delete_metric_filter(
#'   logGroupName = "string",
#'   filterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_metric_filter
cloudwatchlogs_delete_metric_filter <- function(logGroupName, filterName) {
  op <- new_operation(
    name = "DeleteMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_metric_filter_input(logGroupName = logGroupName, filterName = filterName)
  output <- .cloudwatchlogs$delete_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_metric_filter <- cloudwatchlogs_delete_metric_filter

#' Deletes a resource policy from this account
#'
#' Deletes a resource policy from this account. This revokes the access of
#' the identities in that policy to put log events to this account.
#'
#' @usage
#' cloudwatchlogs_delete_resource_policy(policyName)
#'
#' @param policyName The name of the policy to be revoked. This parameter is required.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_policy(
#'   policyName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_resource_policy
cloudwatchlogs_delete_resource_policy <- function(policyName = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_resource_policy_input(policyName = policyName)
  output <- .cloudwatchlogs$delete_resource_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_resource_policy <- cloudwatchlogs_delete_resource_policy

#' Deletes the specified retention policy
#'
#' Deletes the specified retention policy.
#' 
#' Log events do not expire if they belong to log groups without a
#' retention policy.
#'
#' @usage
#' cloudwatchlogs_delete_retention_policy(logGroupName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_retention_policy(
#'   logGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_retention_policy
cloudwatchlogs_delete_retention_policy <- function(logGroupName) {
  op <- new_operation(
    name = "DeleteRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_retention_policy_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$delete_retention_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_retention_policy <- cloudwatchlogs_delete_retention_policy

#' Deletes the specified subscription filter
#'
#' Deletes the specified subscription filter.
#'
#' @usage
#' cloudwatchlogs_delete_subscription_filter(logGroupName, filterName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; The name of the subscription filter.
#'
#' @section Request syntax:
#' ```
#' svc$delete_subscription_filter(
#'   logGroupName = "string",
#'   filterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_delete_subscription_filter
cloudwatchlogs_delete_subscription_filter <- function(logGroupName, filterName) {
  op <- new_operation(
    name = "DeleteSubscriptionFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$delete_subscription_filter_input(logGroupName = logGroupName, filterName = filterName)
  output <- .cloudwatchlogs$delete_subscription_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$delete_subscription_filter <- cloudwatchlogs_delete_subscription_filter

#' Lists all your destinations
#'
#' Lists all your destinations. The results are ASCII-sorted by destination
#' name.
#'
#' @usage
#' cloudwatchlogs_describe_destinations(DestinationNamePrefix, nextToken,
#'   limit)
#'
#' @param DestinationNamePrefix The prefix to match. If you don\'t specify a value, no prefix filter is
#' applied.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#'
#' @section Request syntax:
#' ```
#' svc$describe_destinations(
#'   DestinationNamePrefix = "string",
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_destinations
cloudwatchlogs_describe_destinations <- function(DestinationNamePrefix = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeDestinations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_destinations_input(DestinationNamePrefix = DestinationNamePrefix, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_destinations_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_destinations <- cloudwatchlogs_describe_destinations

#' Lists the specified export tasks
#'
#' Lists the specified export tasks. You can list all your export tasks or
#' filter the results based on task ID or task status.
#'
#' @usage
#' cloudwatchlogs_describe_export_tasks(taskId, statusCode, nextToken,
#'   limit)
#'
#' @param taskId The ID of the export task. Specifying a task ID filters the results to
#' zero or one export tasks.
#' @param statusCode The status code of the export task. Specifying a status code filters the
#' results to zero or more export tasks.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#'
#' @section Request syntax:
#' ```
#' svc$describe_export_tasks(
#'   taskId = "string",
#'   statusCode = "CANCELLED"|"COMPLETED"|"FAILED"|"PENDING"|"PENDING_CANCEL"|"RUNNING",
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_export_tasks
cloudwatchlogs_describe_export_tasks <- function(taskId = NULL, statusCode = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_export_tasks_input(taskId = taskId, statusCode = statusCode, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_export_tasks_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_export_tasks <- cloudwatchlogs_describe_export_tasks

#' Lists the specified log groups
#'
#' Lists the specified log groups. You can list all your log groups or
#' filter the results by prefix. The results are ASCII-sorted by log group
#' name.
#'
#' @usage
#' cloudwatchlogs_describe_log_groups(logGroupNamePrefix, nextToken, limit)
#'
#' @param logGroupNamePrefix The prefix to match.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#'
#' @section Request syntax:
#' ```
#' svc$describe_log_groups(
#'   logGroupNamePrefix = "string",
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_log_groups
cloudwatchlogs_describe_log_groups <- function(logGroupNamePrefix = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeLogGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_log_groups_input(logGroupNamePrefix = logGroupNamePrefix, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_log_groups_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_log_groups <- cloudwatchlogs_describe_log_groups

#' Lists the log streams for the specified log group
#'
#' Lists the log streams for the specified log group. You can list all the
#' log streams or filter the results by prefix. You can also control how
#' the results are ordered.
#' 
#' This operation has a limit of five transactions per second, after which
#' transactions are throttled.
#'
#' @usage
#' cloudwatchlogs_describe_log_streams(logGroupName, logStreamNamePrefix,
#'   orderBy, descending, nextToken, limit)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamNamePrefix The prefix to match.
#' 
#' If `orderBy` is `LastEventTime`,you cannot specify this parameter.
#' @param orderBy If the value is `LogStreamName`, the results are ordered by log stream
#' name. If the value is `LastEventTime`, the results are ordered by the
#' event time. The default value is `LogStreamName`.
#' 
#' If you order the results by event time, you cannot specify the
#' `logStreamNamePrefix` parameter.
#' 
#' lastEventTimestamp represents the time of the most recent log event in
#' the log stream in CloudWatch Logs. This number is expressed as the
#' number of milliseconds after Jan 1, 1970 00:00:00 UTC.
#' lastEventTimeStamp updates on an eventual consistency basis. It
#' typically updates in less than an hour from ingestion, but may take
#' longer in some rare situations.
#' @param descending If the value is true, results are returned in descending order. If the
#' value is to false, results are returned in ascending order. The default
#' value is false.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#'
#' @section Request syntax:
#' ```
#' svc$describe_log_streams(
#'   logGroupName = "string",
#'   logStreamNamePrefix = "string",
#'   orderBy = "LogStreamName"|"LastEventTime",
#'   descending = TRUE|FALSE,
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_log_streams
cloudwatchlogs_describe_log_streams <- function(logGroupName, logStreamNamePrefix = NULL, orderBy = NULL, descending = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeLogStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_log_streams_input(logGroupName = logGroupName, logStreamNamePrefix = logStreamNamePrefix, orderBy = orderBy, descending = descending, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_log_streams_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_log_streams <- cloudwatchlogs_describe_log_streams

#' Lists the specified metric filters
#'
#' Lists the specified metric filters. You can list all the metric filters
#' or filter the results by log name, prefix, metric name, or metric
#' namespace. The results are ASCII-sorted by filter name.
#'
#' @usage
#' cloudwatchlogs_describe_metric_filters(logGroupName, filterNamePrefix,
#'   nextToken, limit, metricName, metricNamespace)
#'
#' @param logGroupName The name of the log group.
#' @param filterNamePrefix The prefix to match.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#' @param metricName Filters results to include only those with the specified metric name. If
#' you include this parameter in your request, you must also include the
#' `metricNamespace` parameter.
#' @param metricNamespace Filters results to include only those in the specified namespace. If you
#' include this parameter in your request, you must also include the
#' `metricName` parameter.
#'
#' @section Request syntax:
#' ```
#' svc$describe_metric_filters(
#'   logGroupName = "string",
#'   filterNamePrefix = "string",
#'   nextToken = "string",
#'   limit = 123,
#'   metricName = "string",
#'   metricNamespace = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_metric_filters
cloudwatchlogs_describe_metric_filters <- function(logGroupName = NULL, filterNamePrefix = NULL, nextToken = NULL, limit = NULL, metricName = NULL, metricNamespace = NULL) {
  op <- new_operation(
    name = "DescribeMetricFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_metric_filters_input(logGroupName = logGroupName, filterNamePrefix = filterNamePrefix, nextToken = nextToken, limit = limit, metricName = metricName, metricNamespace = metricNamespace)
  output <- .cloudwatchlogs$describe_metric_filters_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_metric_filters <- cloudwatchlogs_describe_metric_filters

#' Returns a list of CloudWatch Logs Insights queries that are scheduled,
#' executing, or have been executed recently in this account
#'
#' Returns a list of CloudWatch Logs Insights queries that are scheduled,
#' executing, or have been executed recently in this account. You can
#' request all queries, or limit it to queries of a specific log group or
#' queries with a certain status.
#'
#' @usage
#' cloudwatchlogs_describe_queries(logGroupName, status, maxResults,
#'   nextToken)
#'
#' @param logGroupName Limits the returned queries to only those for the specified log group.
#' @param status Limits the returned queries to only those that have the specified
#' status. Valid values are `Cancelled`, `Complete`, `Failed`, `Running`,
#' and `Scheduled`.
#' @param maxResults Limits the number of returned queries to the specified number.
#' @param nextToken 
#'
#' @section Request syntax:
#' ```
#' svc$describe_queries(
#'   logGroupName = "string",
#'   status = "Scheduled"|"Running"|"Complete"|"Failed"|"Cancelled",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_queries
cloudwatchlogs_describe_queries <- function(logGroupName = NULL, status = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_queries_input(logGroupName = logGroupName, status = status, maxResults = maxResults, nextToken = nextToken)
  output <- .cloudwatchlogs$describe_queries_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_queries <- cloudwatchlogs_describe_queries

#' Lists the resource policies in this account
#'
#' Lists the resource policies in this account.
#'
#' @usage
#' cloudwatchlogs_describe_resource_policies(nextToken, limit)
#'
#' @param nextToken 
#' @param limit The maximum number of resource policies to be displayed with one call of
#' this API.
#'
#' @section Request syntax:
#' ```
#' svc$describe_resource_policies(
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_resource_policies
cloudwatchlogs_describe_resource_policies <- function(nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeResourcePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_resource_policies_input(nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_resource_policies_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_resource_policies <- cloudwatchlogs_describe_resource_policies

#' Lists the subscription filters for the specified log group
#'
#' Lists the subscription filters for the specified log group. You can list
#' all the subscription filters or filter the results by prefix. The
#' results are ASCII-sorted by filter name.
#'
#' @usage
#' cloudwatchlogs_describe_subscription_filters(logGroupName,
#'   filterNamePrefix, nextToken, limit)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterNamePrefix The prefix to match. If you don\'t specify a value, no prefix filter is
#' applied.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of items returned. If you don\'t specify a value, the
#' default is up to 50 items.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subscription_filters(
#'   logGroupName = "string",
#'   filterNamePrefix = "string",
#'   nextToken = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_describe_subscription_filters
cloudwatchlogs_describe_subscription_filters <- function(logGroupName, filterNamePrefix = NULL, nextToken = NULL, limit = NULL) {
  op <- new_operation(
    name = "DescribeSubscriptionFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$describe_subscription_filters_input(logGroupName = logGroupName, filterNamePrefix = filterNamePrefix, nextToken = nextToken, limit = limit)
  output <- .cloudwatchlogs$describe_subscription_filters_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$describe_subscription_filters <- cloudwatchlogs_describe_subscription_filters

#' Disassociates the associated AWS Key Management Service (AWS KMS)
#' customer master key (CMK) from the specified log group
#'
#' Disassociates the associated AWS Key Management Service (AWS KMS)
#' customer master key (CMK) from the specified log group.
#' 
#' After the AWS KMS CMK is disassociated from the log group, AWS
#' CloudWatch Logs stops encrypting newly ingested data for the log group.
#' All previously ingested data remains encrypted, and AWS CloudWatch Logs
#' requires permissions for the CMK whenever the encrypted data is
#' requested.
#' 
#' Note that it can take up to 5 minutes for this operation to take effect.
#'
#' @usage
#' cloudwatchlogs_disassociate_kms_key(logGroupName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_kms_key(
#'   logGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_disassociate_kms_key
cloudwatchlogs_disassociate_kms_key <- function(logGroupName) {
  op <- new_operation(
    name = "DisassociateKmsKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$disassociate_kms_key_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$disassociate_kms_key_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$disassociate_kms_key <- cloudwatchlogs_disassociate_kms_key

#' Lists log events from the specified log group
#'
#' Lists log events from the specified log group. You can list all the log
#' events or filter the results using a filter pattern, a time range, and
#' the name of the log stream.
#' 
#' By default, this operation returns as many log events as can fit in 1 MB
#' (up to 10,000 log events), or all the events found within the time range
#' that you specify. If the results include a token, then there are more
#' log events available, and you can get additional results by specifying
#' the token in a subsequent call.
#'
#' @usage
#' cloudwatchlogs_filter_log_events(logGroupName, logStreamNames,
#'   logStreamNamePrefix, startTime, endTime, filterPattern, nextToken,
#'   limit, interleaved)
#'
#' @param logGroupName &#91;required&#93; The name of the log group to search.
#' @param logStreamNames Filters the results to only logs from the log streams in this list.
#' 
#' If you specify a value for both `logStreamNamePrefix` and
#' `logStreamNames`, the action returns an `InvalidParameterException`
#' error.
#' @param logStreamNamePrefix Filters the results to include only events from log streams that have
#' names starting with this prefix.
#' 
#' If you specify a value for both `logStreamNamePrefix` and
#' `logStreamNames`, but the value for `logStreamNamePrefix` does not match
#' any log stream names specified in `logStreamNames`, the action returns
#' an `InvalidParameterException` error.
#' @param startTime The start of the time range, expressed as the number of milliseconds
#' after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time
#' are not returned.
#' @param endTime The end of the time range, expressed as the number of milliseconds after
#' Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time
#' are not returned.
#' @param filterPattern The filter pattern to use. For more information, see [Filter and Pattern
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html).
#' 
#' If not provided, all the events are matched.
#' @param nextToken The token for the next set of events to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of events to return. The default is 10,000 events.
#' @param interleaved If the value is true, the operation makes a best effort to provide
#' responses that contain events from multiple log streams within the log
#' group, interleaved in a single response. If the value is false, all the
#' matched log events in the first log stream are searched first, then
#' those in the next log stream, and so on. The default is false.
#' 
#' **IMPORTANT:** Starting on June 17, 2019, this parameter will be ignored
#' and the value will be assumed to be true. The response from this
#' operation will always interleave events from multiple log streams within
#' a log group.
#'
#' @section Request syntax:
#' ```
#' svc$filter_log_events(
#'   logGroupName = "string",
#'   logStreamNames = list(
#'     "string"
#'   ),
#'   logStreamNamePrefix = "string",
#'   startTime = 123,
#'   endTime = 123,
#'   filterPattern = "string",
#'   nextToken = "string",
#'   limit = 123,
#'   interleaved = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_filter_log_events
cloudwatchlogs_filter_log_events <- function(logGroupName, logStreamNames = NULL, logStreamNamePrefix = NULL, startTime = NULL, endTime = NULL, filterPattern = NULL, nextToken = NULL, limit = NULL, interleaved = NULL) {
  op <- new_operation(
    name = "FilterLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$filter_log_events_input(logGroupName = logGroupName, logStreamNames = logStreamNames, logStreamNamePrefix = logStreamNamePrefix, startTime = startTime, endTime = endTime, filterPattern = filterPattern, nextToken = nextToken, limit = limit, interleaved = interleaved)
  output <- .cloudwatchlogs$filter_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$filter_log_events <- cloudwatchlogs_filter_log_events

#' Lists log events from the specified log stream
#'
#' Lists log events from the specified log stream. You can list all the log
#' events or filter using a time range.
#' 
#' By default, this operation returns as many log events as can fit in a
#' response size of 1MB (up to 10,000 log events). You can get additional
#' log events by specifying one of the tokens in a subsequent call.
#'
#' @usage
#' cloudwatchlogs_get_log_events(logGroupName, logStreamName, startTime,
#'   endTime, nextToken, limit, startFromHead)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' @param startTime The start of the time range, expressed as the number of milliseconds
#' after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this
#' time or later than this time are included. Events with a timestamp
#' earlier than this time are not included.
#' @param endTime The end of the time range, expressed as the number of milliseconds after
#' Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than
#' this time are not included.
#' @param nextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param limit The maximum number of log events returned. If you don\'t specify a
#' value, the maximum is as many log events as can fit in a response size
#' of 1 MB, up to 10,000 log events.
#' @param startFromHead If the value is true, the earliest log events are returned first. If the
#' value is false, the latest log events are returned first. The default
#' value is false.
#'
#' @section Request syntax:
#' ```
#' svc$get_log_events(
#'   logGroupName = "string",
#'   logStreamName = "string",
#'   startTime = 123,
#'   endTime = 123,
#'   nextToken = "string",
#'   limit = 123,
#'   startFromHead = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_events
cloudwatchlogs_get_log_events <- function(logGroupName, logStreamName, startTime = NULL, endTime = NULL, nextToken = NULL, limit = NULL, startFromHead = NULL) {
  op <- new_operation(
    name = "GetLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_events_input(logGroupName = logGroupName, logStreamName = logStreamName, startTime = startTime, endTime = endTime, nextToken = nextToken, limit = limit, startFromHead = startFromHead)
  output <- .cloudwatchlogs$get_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_events <- cloudwatchlogs_get_log_events

#' Returns a list of the fields that are included in log events in the
#' specified log group, along with the percentage of log events that
#' contain each field
#'
#' Returns a list of the fields that are included in log events in the
#' specified log group, along with the percentage of log events that
#' contain each field. The search is limited to a time period that you
#' specify.
#' 
#' In the results, fields that start with @ are fields generated by
#' CloudWatch Logs. For example, `@timestamp` is the timestamp of each log
#' event.
#' 
#' The response results are sorted by the frequency percentage, starting
#' with the highest percentage.
#'
#' @usage
#' cloudwatchlogs_get_log_group_fields(logGroupName, time)
#'
#' @param logGroupName &#91;required&#93; The name of the log group to search.
#' @param time The time to set as the center of the query. If you specify `time`, the 8
#' minutes before and 8 minutes after this time are searched. If you omit
#' `time`, the past 15 minutes are queried.
#' 
#' The `time` value is specified as epoch time, the number of seconds since
#' January 1, 1970, 00:00:00 UTC.
#'
#' @section Request syntax:
#' ```
#' svc$get_log_group_fields(
#'   logGroupName = "string",
#'   time = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_group_fields
cloudwatchlogs_get_log_group_fields <- function(logGroupName, time = NULL) {
  op <- new_operation(
    name = "GetLogGroupFields",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_group_fields_input(logGroupName = logGroupName, time = time)
  output <- .cloudwatchlogs$get_log_group_fields_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_group_fields <- cloudwatchlogs_get_log_group_fields

#' Retrieves all the fields and values of a single log event
#'
#' Retrieves all the fields and values of a single log event. All fields
#' are retrieved, even if the original query that produced the
#' `logRecordPointer` retrieved only a subset of fields. Fields are
#' returned as field name/field value pairs.
#' 
#' Additionally, the entire unparsed log event is returned within
#' `@message`.
#'
#' @usage
#' cloudwatchlogs_get_log_record(logRecordPointer)
#'
#' @param logRecordPointer &#91;required&#93; The pointer corresponding to the log event record you want to retrieve.
#' You get this from the response of a `GetQueryResults` operation. In that
#' response, the value of the `@ptr` field for a log event is the value to
#' use as `logRecordPointer` to retrieve that complete log event record.
#'
#' @section Request syntax:
#' ```
#' svc$get_log_record(
#'   logRecordPointer = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_log_record
cloudwatchlogs_get_log_record <- function(logRecordPointer) {
  op <- new_operation(
    name = "GetLogRecord",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_log_record_input(logRecordPointer = logRecordPointer)
  output <- .cloudwatchlogs$get_log_record_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_log_record <- cloudwatchlogs_get_log_record

#' Returns the results from the specified query
#'
#' Returns the results from the specified query. If the query is in
#' progress, partial results of that current execution are returned.
#' 
#' Only the fields requested in the query are returned, along with a `@ptr`
#' field which is the identifier for the log record. You can use the value
#' of `@ptr` in a operation to get the full log record.
#' 
#' `GetQueryResults` does not start a query execution. To run a query, use
#' .
#'
#' @usage
#' cloudwatchlogs_get_query_results(queryId)
#'
#' @param queryId &#91;required&#93; The ID number of the query.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_results(
#'   queryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_get_query_results
cloudwatchlogs_get_query_results <- function(queryId) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$get_query_results_input(queryId = queryId)
  output <- .cloudwatchlogs$get_query_results_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$get_query_results <- cloudwatchlogs_get_query_results

#' Lists the tags for the specified log group
#'
#' Lists the tags for the specified log group.
#'
#' @usage
#' cloudwatchlogs_list_tags_log_group(logGroupName)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_log_group(
#'   logGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_list_tags_log_group
cloudwatchlogs_list_tags_log_group <- function(logGroupName) {
  op <- new_operation(
    name = "ListTagsLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$list_tags_log_group_input(logGroupName = logGroupName)
  output <- .cloudwatchlogs$list_tags_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$list_tags_log_group <- cloudwatchlogs_list_tags_log_group

#' Creates or updates a destination
#'
#' Creates or updates a destination. A destination encapsulates a physical
#' resource (such as an Amazon Kinesis stream) and enables you to subscribe
#' to a real-time stream of log events for a different account, ingested
#' using PutLogEvents. Currently, the only supported physical resource is a
#' Kinesis stream belonging to the same account as the destination.
#' 
#' Through an access policy, a destination controls what is written to its
#' Kinesis stream. By default, `PutDestination` does not set any access
#' policy with the destination, which means a cross-account user cannot
#' call PutSubscriptionFilter against this destination. To enable this, the
#' destination owner must call PutDestinationPolicy after `PutDestination`.
#'
#' @usage
#' cloudwatchlogs_put_destination(destinationName, targetArn, roleArn)
#'
#' @param destinationName &#91;required&#93; A name for the destination.
#' @param targetArn &#91;required&#93; The ARN of an Amazon Kinesis stream to which to deliver matching log
#' events.
#' @param roleArn &#91;required&#93; The ARN of an IAM role that grants CloudWatch Logs permissions to call
#' the Amazon Kinesis PutRecord operation on the destination stream.
#'
#' @section Request syntax:
#' ```
#' svc$put_destination(
#'   destinationName = "string",
#'   targetArn = "string",
#'   roleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_destination
cloudwatchlogs_put_destination <- function(destinationName, targetArn, roleArn) {
  op <- new_operation(
    name = "PutDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_destination_input(destinationName = destinationName, targetArn = targetArn, roleArn = roleArn)
  output <- .cloudwatchlogs$put_destination_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_destination <- cloudwatchlogs_put_destination

#' Creates or updates an access policy associated with an existing
#' destination
#'
#' Creates or updates an access policy associated with an existing
#' destination. An access policy is an [IAM policy
#' document](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
#' that is used to authorize claims to register a subscription filter
#' against a given destination.
#'
#' @usage
#' cloudwatchlogs_put_destination_policy(destinationName, accessPolicy)
#'
#' @param destinationName &#91;required&#93; A name for an existing destination.
#' @param accessPolicy &#91;required&#93; An IAM policy document that authorizes cross-account users to deliver
#' their log events to the associated destination.
#'
#' @section Request syntax:
#' ```
#' svc$put_destination_policy(
#'   destinationName = "string",
#'   accessPolicy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_destination_policy
cloudwatchlogs_put_destination_policy <- function(destinationName, accessPolicy) {
  op <- new_operation(
    name = "PutDestinationPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_destination_policy_input(destinationName = destinationName, accessPolicy = accessPolicy)
  output <- .cloudwatchlogs$put_destination_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_destination_policy <- cloudwatchlogs_put_destination_policy

#' Uploads a batch of log events to the specified log stream
#'
#' Uploads a batch of log events to the specified log stream.
#' 
#' You must include the sequence token obtained from the response of the
#' previous call. An upload in a newly created log stream does not require
#' a sequence token. You can also get the sequence token using
#' DescribeLogStreams. If you call `PutLogEvents` twice within a narrow
#' time period using the same value for `sequenceToken`, both calls may be
#' successful, or one may be rejected.
#' 
#' The batch of events must satisfy the following constraints:
#' 
#' -   The maximum batch size is 1,048,576 bytes, and this size is
#'     calculated as the sum of all event messages in UTF-8, plus 26 bytes
#'     for each log event.
#' 
#' -   None of the log events in the batch can be more than 2 hours in the
#'     future.
#' 
#' -   None of the log events in the batch can be older than 14 days or
#'     older than the retention period of the log group.
#' 
#' -   The log events in the batch must be in chronological ordered by
#'     their timestamp. The timestamp is the time the event occurred,
#'     expressed as the number of milliseconds after Jan 1, 1970 00:00:00
#'     UTC. (In AWS Tools for PowerShell and the AWS SDK for .NET, the
#'     timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss. For
#'     example, 2017-09-15T13:45:30.)
#' 
#' -   The maximum number of log events in a batch is 10,000.
#' 
#' -   A batch of log events in a single request cannot span more than 24
#'     hours. Otherwise, the operation fails.
#' 
#' If a call to PutLogEvents returns \"UnrecognizedClientException\" the
#' most likely cause is an invalid AWS access key ID or secret key.
#'
#' @usage
#' cloudwatchlogs_put_log_events(logGroupName, logStreamName, logEvents,
#'   sequenceToken)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' @param logEvents &#91;required&#93; The log events.
#' @param sequenceToken The sequence token obtained from the response of the previous
#' `PutLogEvents` call. An upload in a newly created log stream does not
#' require a sequence token. You can also get the sequence token using
#' DescribeLogStreams. If you call `PutLogEvents` twice within a narrow
#' time period using the same value for `sequenceToken`, both calls may be
#' successful, or one may be rejected.
#'
#' @section Request syntax:
#' ```
#' svc$put_log_events(
#'   logGroupName = "string",
#'   logStreamName = "string",
#'   logEvents = list(
#'     list(
#'       timestamp = 123,
#'       message = "string"
#'     )
#'   ),
#'   sequenceToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_log_events
cloudwatchlogs_put_log_events <- function(logGroupName, logStreamName, logEvents, sequenceToken = NULL) {
  op <- new_operation(
    name = "PutLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_log_events_input(logGroupName = logGroupName, logStreamName = logStreamName, logEvents = logEvents, sequenceToken = sequenceToken)
  output <- .cloudwatchlogs$put_log_events_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_log_events <- cloudwatchlogs_put_log_events

#' Creates or updates a metric filter and associates it with the specified
#' log group
#'
#' Creates or updates a metric filter and associates it with the specified
#' log group. Metric filters allow you to configure rules to extract metric
#' data from log events ingested through PutLogEvents.
#' 
#' The maximum number of metric filters that can be associated with a log
#' group is 100.
#'
#' @usage
#' cloudwatchlogs_put_metric_filter(logGroupName, filterName,
#'   filterPattern, metricTransformations)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; A name for the metric filter.
#' @param filterPattern &#91;required&#93; A filter pattern for extracting metric data out of ingested log events.
#' @param metricTransformations &#91;required&#93; A collection of information that defines how metric data gets emitted.
#'
#' @section Request syntax:
#' ```
#' svc$put_metric_filter(
#'   logGroupName = "string",
#'   filterName = "string",
#'   filterPattern = "string",
#'   metricTransformations = list(
#'     list(
#'       metricName = "string",
#'       metricNamespace = "string",
#'       metricValue = "string",
#'       defaultValue = 123.0
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_metric_filter
cloudwatchlogs_put_metric_filter <- function(logGroupName, filterName, filterPattern, metricTransformations) {
  op <- new_operation(
    name = "PutMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_metric_filter_input(logGroupName = logGroupName, filterName = filterName, filterPattern = filterPattern, metricTransformations = metricTransformations)
  output <- .cloudwatchlogs$put_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_metric_filter <- cloudwatchlogs_put_metric_filter

#' Creates or updates a resource policy allowing other AWS services to put
#' log events to this account, such as Amazon Route 53
#'
#' Creates or updates a resource policy allowing other AWS services to put
#' log events to this account, such as Amazon Route 53. An account can have
#' up to 10 resource policies per region.
#'
#' @usage
#' cloudwatchlogs_put_resource_policy(policyName, policyDocument)
#'
#' @param policyName Name of the new policy. This parameter is required.
#' @param policyDocument Details of the new policy, including the identity of the principal that
#' is enabled to put logs to this account. This is formatted as a JSON
#' string. This parameter is required.
#' 
#' The following example creates a resource policy enabling the Route 53
#' service to put DNS query logs in to the specified log group. Replace
#' \"logArn\" with the ARN of your CloudWatch Logs resource, such as a log
#' group or log stream.
#' 
#' `\{ "Version": "2012-10-17", "Statement": \\[ \{ "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": \{ "Service": \\[ "route53.amazonaws.com" \\] \}, "Action":"logs:PutLogEvents", "Resource": "logArn" \} \\] \} `
#'
#' @section Request syntax:
#' ```
#' svc$put_resource_policy(
#'   policyName = "string",
#'   policyDocument = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_resource_policy
cloudwatchlogs_put_resource_policy <- function(policyName = NULL, policyDocument = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_resource_policy_input(policyName = policyName, policyDocument = policyDocument)
  output <- .cloudwatchlogs$put_resource_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_resource_policy <- cloudwatchlogs_put_resource_policy

#' Sets the retention of the specified log group
#'
#' Sets the retention of the specified log group. A retention policy allows
#' you to configure the number of days for which to retain log events in
#' the specified log group.
#'
#' @usage
#' cloudwatchlogs_put_retention_policy(logGroupName, retentionInDays)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param retentionInDays &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_retention_policy(
#'   logGroupName = "string",
#'   retentionInDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_retention_policy
cloudwatchlogs_put_retention_policy <- function(logGroupName, retentionInDays) {
  op <- new_operation(
    name = "PutRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_retention_policy_input(logGroupName = logGroupName, retentionInDays = retentionInDays)
  output <- .cloudwatchlogs$put_retention_policy_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_retention_policy <- cloudwatchlogs_put_retention_policy

#' Creates or updates a subscription filter and associates it with the
#' specified log group
#'
#' Creates or updates a subscription filter and associates it with the
#' specified log group. Subscription filters allow you to subscribe to a
#' real-time stream of log events ingested through PutLogEvents and have
#' them delivered to a specific destination. Currently, the supported
#' destinations are:
#' 
#' -   An Amazon Kinesis stream belonging to the same account as the
#'     subscription filter, for same-account delivery.
#' 
#' -   A logical destination that belongs to a different account, for
#'     cross-account delivery.
#' 
#' -   An Amazon Kinesis Firehose delivery stream that belongs to the same
#'     account as the subscription filter, for same-account delivery.
#' 
#' -   An AWS Lambda function that belongs to the same account as the
#'     subscription filter, for same-account delivery.
#' 
#' There can only be one subscription filter associated with a log group.
#' If you are updating an existing filter, you must specify the correct
#' name in `filterName`. Otherwise, the call fails because you cannot
#' associate a second filter with a log group.
#'
#' @usage
#' cloudwatchlogs_put_subscription_filter(logGroupName, filterName,
#'   filterPattern, destinationArn, roleArn, distribution)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param filterName &#91;required&#93; A name for the subscription filter. If you are updating an existing
#' filter, you must specify the correct name in `filterName`. Otherwise,
#' the call fails because you cannot associate a second filter with a log
#' group. To find the name of the filter currently associated with a log
#' group, use DescribeSubscriptionFilters.
#' @param filterPattern &#91;required&#93; A filter pattern for subscribing to a filtered stream of log events.
#' @param destinationArn &#91;required&#93; The ARN of the destination to deliver matching log events to. Currently,
#' the supported destinations are:
#' 
#' -   An Amazon Kinesis stream belonging to the same account as the
#'     subscription filter, for same-account delivery.
#' 
#' -   A logical destination (specified using an ARN) belonging to a
#'     different account, for cross-account delivery.
#' 
#' -   An Amazon Kinesis Firehose delivery stream belonging to the same
#'     account as the subscription filter, for same-account delivery.
#' 
#' -   An AWS Lambda function belonging to the same account as the
#'     subscription filter, for same-account delivery.
#' @param roleArn The ARN of an IAM role that grants CloudWatch Logs permissions to
#' deliver ingested log events to the destination stream. You don\'t need
#' to provide the ARN when you are working with a logical destination for
#' cross-account delivery.
#' @param distribution The method used to distribute log data to the destination. By default
#' log data is grouped by log stream, but the grouping can be set to random
#' for a more even distribution. This property is only applicable when the
#' destination is an Amazon Kinesis stream.
#'
#' @section Request syntax:
#' ```
#' svc$put_subscription_filter(
#'   logGroupName = "string",
#'   filterName = "string",
#'   filterPattern = "string",
#'   destinationArn = "string",
#'   roleArn = "string",
#'   distribution = "Random"|"ByLogStream"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_put_subscription_filter
cloudwatchlogs_put_subscription_filter <- function(logGroupName, filterName, filterPattern, destinationArn, roleArn = NULL, distribution = NULL) {
  op <- new_operation(
    name = "PutSubscriptionFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$put_subscription_filter_input(logGroupName = logGroupName, filterName = filterName, filterPattern = filterPattern, destinationArn = destinationArn, roleArn = roleArn, distribution = distribution)
  output <- .cloudwatchlogs$put_subscription_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$put_subscription_filter <- cloudwatchlogs_put_subscription_filter

#' Schedules a query of a log group using CloudWatch Logs Insights
#'
#' Schedules a query of a log group using CloudWatch Logs Insights. You
#' specify the log group and time range to query, and the query string to
#' use.
#' 
#' For more information, see [CloudWatch Logs Insights Query
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
#' 
#' Queries time out after 15 minutes of execution. If your queries are
#' timing out, reduce the time range being searched, or partition your
#' query into a number of queries.
#'
#' @usage
#' cloudwatchlogs_start_query(logGroupName, startTime, endTime,
#'   queryString, limit)
#'
#' @param logGroupName &#91;required&#93; The log group on which to perform the query.
#' @param startTime &#91;required&#93; The beginning of the time range to query. The range is inclusive, so the
#' specified start time is included in the query. Specified as epoch time,
#' the number of seconds since January 1, 1970, 00:00:00 UTC.
#' @param endTime &#91;required&#93; The end of the time range to query. The range is inclusive, so the
#' specified end time is included in the query. Specified as epoch time,
#' the number of seconds since January 1, 1970, 00:00:00 UTC.
#' @param queryString &#91;required&#93; The query string to use. For more information, see [CloudWatch Logs
#' Insights Query
#' Syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html).
#' @param limit The maximum number of log events to return in the query. If the query
#' string uses the `fields` command, only the specified fields and their
#' values are returned.
#'
#' @section Request syntax:
#' ```
#' svc$start_query(
#'   logGroupName = "string",
#'   startTime = 123,
#'   endTime = 123,
#'   queryString = "string",
#'   limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_start_query
cloudwatchlogs_start_query <- function(logGroupName, startTime, endTime, queryString, limit = NULL) {
  op <- new_operation(
    name = "StartQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$start_query_input(logGroupName = logGroupName, startTime = startTime, endTime = endTime, queryString = queryString, limit = limit)
  output <- .cloudwatchlogs$start_query_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$start_query <- cloudwatchlogs_start_query

#' Stops a CloudWatch Logs Insights query that is in progress
#'
#' Stops a CloudWatch Logs Insights query that is in progress. If the query
#' has already ended, the operation returns an error indicating that the
#' specified query is not running.
#'
#' @usage
#' cloudwatchlogs_stop_query(queryId)
#'
#' @param queryId &#91;required&#93; The ID number of the query to stop. If necessary, you can use
#' `DescribeQueries` to find this ID number.
#'
#' @section Request syntax:
#' ```
#' svc$stop_query(
#'   queryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_stop_query
cloudwatchlogs_stop_query <- function(queryId) {
  op <- new_operation(
    name = "StopQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$stop_query_input(queryId = queryId)
  output <- .cloudwatchlogs$stop_query_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$stop_query <- cloudwatchlogs_stop_query

#' Adds or updates the specified tags for the specified log group
#'
#' Adds or updates the specified tags for the specified log group.
#' 
#' To list the tags for a log group, use ListTagsLogGroup. To remove tags,
#' use UntagLogGroup.
#' 
#' For more information about tags, see [Tag Log Groups in Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/log-group-tagging.html)
#' in the *Amazon CloudWatch Logs User Guide*.
#'
#' @usage
#' cloudwatchlogs_tag_log_group(logGroupName, tags)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param tags &#91;required&#93; The key-value pairs to use for the tags.
#'
#' @section Request syntax:
#' ```
#' svc$tag_log_group(
#'   logGroupName = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_tag_log_group
cloudwatchlogs_tag_log_group <- function(logGroupName, tags) {
  op <- new_operation(
    name = "TagLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$tag_log_group_input(logGroupName = logGroupName, tags = tags)
  output <- .cloudwatchlogs$tag_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$tag_log_group <- cloudwatchlogs_tag_log_group

#' Tests the filter pattern of a metric filter against a sample of log
#' event messages
#'
#' Tests the filter pattern of a metric filter against a sample of log
#' event messages. You can use this operation to validate the correctness
#' of a metric filter pattern.
#'
#' @usage
#' cloudwatchlogs_test_metric_filter(filterPattern, logEventMessages)
#'
#' @param filterPattern &#91;required&#93; 
#' @param logEventMessages &#91;required&#93; The log event messages to test.
#'
#' @section Request syntax:
#' ```
#' svc$test_metric_filter(
#'   filterPattern = "string",
#'   logEventMessages = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_test_metric_filter
cloudwatchlogs_test_metric_filter <- function(filterPattern, logEventMessages) {
  op <- new_operation(
    name = "TestMetricFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$test_metric_filter_input(filterPattern = filterPattern, logEventMessages = logEventMessages)
  output <- .cloudwatchlogs$test_metric_filter_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$test_metric_filter <- cloudwatchlogs_test_metric_filter

#' Removes the specified tags from the specified log group
#'
#' Removes the specified tags from the specified log group.
#' 
#' To list the tags for a log group, use ListTagsLogGroup. To add tags, use
#' UntagLogGroup.
#'
#' @usage
#' cloudwatchlogs_untag_log_group(logGroupName, tags)
#'
#' @param logGroupName &#91;required&#93; The name of the log group.
#' @param tags &#91;required&#93; The tag keys. The corresponding tags are removed from the log group.
#'
#' @section Request syntax:
#' ```
#' svc$untag_log_group(
#'   logGroupName = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchlogs_untag_log_group
cloudwatchlogs_untag_log_group <- function(logGroupName, tags) {
  op <- new_operation(
    name = "UntagLogGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchlogs$untag_log_group_input(logGroupName = logGroupName, tags = tags)
  output <- .cloudwatchlogs$untag_log_group_output()
  config <- get_config()
  svc <- .cloudwatchlogs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchlogs$operations$untag_log_group <- cloudwatchlogs_untag_log_group
