% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_scaling_policy}
\alias{autoscaling_put_scaling_policy}
\title{Creates or updates a policy for an Auto Scaling group}
\usage{
autoscaling_put_scaling_policy(AutoScalingGroupName, PolicyName,
  PolicyType, AdjustmentType, MinAdjustmentStep, MinAdjustmentMagnitude,
  ScalingAdjustment, Cooldown, MetricAggregationType, StepAdjustments,
  EstimatedInstanceWarmup, TargetTrackingConfiguration)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name of the policy.}

\item{PolicyType}{The policy type. The valid values are \code{SimpleScaling}, \code{StepScaling},
and \code{TargetTrackingScaling}. If the policy type is null, the value is
treated as \code{SimpleScaling}.}

\item{AdjustmentType}{The adjustment type. The valid values are \code{ChangeInCapacity},
\code{ExactCapacity}, and \code{PercentChangeInCapacity}.

This parameter is supported if the policy type is \code{SimpleScaling} or
\code{StepScaling}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scale-based-on-demand.html}{Dynamic Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinAdjustmentStep}{Available for backward compatibility. Use \code{MinAdjustmentMagnitude}
instead.}

\item{MinAdjustmentMagnitude}{The minimum number of instances to scale. If the value of
\code{AdjustmentType} is \code{PercentChangeInCapacity}, the scaling policy
changes the \code{DesiredCapacity} of the Auto Scaling group by at least this
many instances. Otherwise, the error is \code{ValidationError}.

This parameter is supported if the policy type is \code{SimpleScaling} or
\code{StepScaling}.}

\item{ScalingAdjustment}{The amount by which to scale, based on the specified adjustment type. A
positive value adds to the current capacity while a negative number
removes from the current capacity.

Conditional: This parameter is required if the policy type is
\code{SimpleScaling} and not supported otherwise.}

\item{Cooldown}{The amount of time, in seconds, after a scaling activity completes and
before the next scaling activity can start. If this parameter is not
specified, the default cooldown period for the group applies.

This parameter is supported if the policy type is \code{SimpleScaling}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling Cooldowns}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MetricAggregationType}{The aggregation type for the CloudWatch metrics. The valid values are
\code{Minimum}, \code{Maximum}, and \code{Average}. If the aggregation type is null,
the value is treated as \code{Average}.

This parameter is supported if the policy type is \code{StepScaling}.}

\item{StepAdjustments}{A set of adjustments that enable you to scale based on the size of the
alarm breach.

Conditional: This parameter is required if the policy type is
\code{StepScaling} and not supported otherwise.}

\item{EstimatedInstanceWarmup}{The estimated time, in seconds, until a newly launched instance can
contribute to the CloudWatch metrics. The default is to use the value
specified for the default cooldown period for the group.

This parameter is supported if the policy type is \code{StepScaling} or
\code{TargetTrackingScaling}.}

\item{TargetTrackingConfiguration}{A target tracking scaling policy. Includes support for predefined or
customized metrics.

Conditional: This parameter is required if the policy type is
\code{TargetTrackingScaling} and not supported otherwise.}
}
\description{
Creates or updates a policy for an Auto Scaling group. To update an
existing policy, use the existing policy name and set the parameters to
change. Any existing parameter not changed in an update to an existing
policy is not changed in this update request.
}
\section{Request syntax}{
\preformatted{svc$put_scaling_policy(
  AutoScalingGroupName = "string",
  PolicyName = "string",
  PolicyType = "string",
  AdjustmentType = "string",
  MinAdjustmentStep = 123,
  MinAdjustmentMagnitude = 123,
  ScalingAdjustment = 123,
  Cooldown = 123,
  MetricAggregationType = "string",
  StepAdjustments = list(
    list(
      MetricIntervalLowerBound = 123.0,
      MetricIntervalUpperBound = 123.0,
      ScalingAdjustment = 123
    )
  ),
  EstimatedInstanceWarmup = 123,
  TargetTrackingConfiguration = list(
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"ALBRequestCountPerTarget",
      ResourceLabel = "string"
    ),
    CustomizedMetricSpecification = list(
      MetricName = "string",
      Namespace = "string",
      Dimensions = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
      Unit = "string"
    ),
    TargetValue = 123.0,
    DisableScaleIn = TRUE|FALSE
  )
)
}
}

\examples{
# This example adds the specified policy to the specified Auto Scaling
# group.
\donttest{svc$put_scaling_policy(
  AdjustmentType = "ChangeInCapacity",
  AutoScalingGroupName = "my-auto-scaling-group",
  PolicyName = "ScaleIn",
  ScalingAdjustment = -1L
)}

}
\keyword{internal}
