% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_presigned_mlflow_tracking_server_url}
\alias{sagemaker_create_presigned_mlflow_tracking_server_url}
\title{Returns a presigned URL that you can use to connect to the MLflow UI
attached to your tracking server}
\usage{
sagemaker_create_presigned_mlflow_tracking_server_url(
  TrackingServerName,
  ExpiresInSeconds = NULL,
  SessionExpirationDurationInSeconds = NULL
)
}
\arguments{
\item{TrackingServerName}{[required] The name of the tracking server to connect to your MLflow UI.}

\item{ExpiresInSeconds}{The duration in seconds that your presigned URL is valid. The presigned
URL can be used only once.}

\item{SessionExpirationDurationInSeconds}{The duration in seconds that your MLflow UI session is valid.}
}
\description{
Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html}{Launch the MLflow UI using a presigned URL}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_presigned_mlflow_tracking_server_url/} for full documentation.
}
\keyword{internal}
