% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_update_retraining_scheduler}
\alias{lookoutequipment_update_retraining_scheduler}
\title{Updates a retraining scheduler}
\usage{
lookoutequipment_update_retraining_scheduler(
  ModelName,
  RetrainingStartDate = NULL,
  RetrainingFrequency = NULL,
  LookbackWindow = NULL,
  PromoteMode = NULL
)
}
\arguments{
\item{ModelName}{[required] The name of the model whose retraining scheduler you want to update.}

\item{RetrainingStartDate}{The start date for the retraining scheduler. Lookout for Equipment
truncates the time you provide to the nearest UTC day.}

\item{RetrainingFrequency}{This parameter uses the \href{https://en.wikipedia.org/wiki/ISO_8601#Durations}{ISO 8601} standard to set
the frequency at which you want retraining to occur in terms of Years,
Months, and/or Days (note: other parameters like Time are not currently
supported). The minimum value is 30 days (P30D) and the maximum value is
1 year (P1Y). For example, the following values are valid:
\itemize{
\item P3M15D – Every 3 months and 15 days
\item P2M – Every 2 months
\item P150D – Every 150 days
}}

\item{LookbackWindow}{The number of past days of data that will be used for retraining.}

\item{PromoteMode}{Indicates how the service will use new models. In \code{MANAGED} mode, new
models will automatically be used for inference if they have better
performance than the current model. In \code{MANUAL} mode, the new models
will not be used \href{https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation}{until they are manually activated}.}
}
\description{
Updates a retraining scheduler.

See \url{https://www.paws-r-sdk.com/docs/lookoutequipment_update_retraining_scheduler/} for full documentation.
}
\keyword{internal}
