% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_create_adapter_version}
\alias{textract_create_adapter_version}
\title{Creates a new version of an adapter}
\usage{
textract_create_adapter_version(
  AdapterId,
  ClientRequestToken = NULL,
  DatasetConfig,
  KMSKeyId = NULL,
  OutputConfig,
  Tags = NULL
)
}
\arguments{
\item{AdapterId}{[required] A string containing a unique ID for the adapter that will receive a new
version.}

\item{ClientRequestToken}{Idempotent token is used to recognize the request. If the same token is
used with multiple CreateAdapterVersion requests, the same session is
returned. This token is employed to avoid unintentionally creating the
same session multiple times.}

\item{DatasetConfig}{[required] Specifies a dataset used to train a new adapter version. Takes a
ManifestS3Object as the value.}

\item{KMSKeyId}{The identifier for your AWS Key Management Service key (AWS KMS key).
Used to encrypt your documents.}

\item{OutputConfig}{[required]}

\item{Tags}{A set of tags (key-value pairs) that you want to attach to the adapter
version.}
}
\description{
Creates a new version of an adapter. Operates on a provided AdapterId and a specified dataset provided via the DatasetConfig argument. Requires that you specify an Amazon S3 bucket with the OutputConfig argument. You can provide an optional KMSKeyId, an optional ClientRequestToken, and optional tags.

See \url{https://www.paws-r-sdk.com/docs/textract_create_adapter_version/} for full documentation.
}
\keyword{internal}
