# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrockruntime_service.R
NULL

#' Invokes the specified Amazon Bedrock model to run inference using the
#' prompt and inference parameters provided in the request body
#'
#' @description
#' Invokes the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. You use model inference to generate text, images, and embeddings.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model/](https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model/) for full documentation.
#'
#' @param body &#91;required&#93; The prompt and inference parameters in the format specified in the
#' `contentType` in the header. To see the format and content of the
#' request and response bodies for different models, refer to [Inference
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' For more information, see [Run
#' inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference.html)
#' in the Bedrock User Guide.
#' @param contentType The MIME type of the input data in the request. The default value is
#' `application/json`.
#' @param accept The desired MIME type of the inference body in the response. The default
#' value is `application/json`.
#' @param modelId &#91;required&#93; The unique identifier of the model to invoke to run inference.
#' 
#' The `modelId` to provide depends on the type of model that you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' @param trace Specifies whether to enable or disable the Bedrock trace. If enabled,
#' you can see the full Bedrock trace.
#' @param guardrailIdentifier The unique identifier of the guardrail that you want to use. If you
#' don't provide a value, no guardrail is applied to the invocation.
#' 
#' An error will be thrown in the following situations.
#' 
#' -   You don't provide a guardrail identifier but you specify the
#'     `amazon-bedrock-guardrailConfig` field in the request body.
#' 
#' -   You enable the guardrail but the `contentType` isn't
#'     `application/json`.
#' 
#' -   You provide a guardrail identifier, but `guardrailVersion` isn't
#'     specified.
#' @param guardrailVersion The version number for the guardrail. The value can also be `DRAFT`.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_invoke_model
bedrockruntime_invoke_model <- function(body, contentType = NULL, accept = NULL, modelId, trace = NULL, guardrailIdentifier = NULL, guardrailVersion = NULL) {
  op <- new_operation(
    name = "InvokeModel",
    http_method = "POST",
    http_path = "/model/{modelId}/invoke",
    paginator = list()
  )
  input <- .bedrockruntime$invoke_model_input(body = body, contentType = contentType, accept = accept, modelId = modelId, trace = trace, guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion)
  output <- .bedrockruntime$invoke_model_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$invoke_model <- bedrockruntime_invoke_model

#' Invoke the specified Amazon Bedrock model to run inference using the
#' prompt and inference parameters provided in the request body
#'
#' @description
#' Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. The response is returned in a stream.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model_with_response_stream/](https://www.paws-r-sdk.com/docs/bedrockruntime_invoke_model_with_response_stream/) for full documentation.
#'
#' @param body &#91;required&#93; The prompt and inference parameters in the format specified in the
#' `contentType` in the header. To see the format and content of the
#' request and response bodies for different models, refer to [Inference
#' parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
#' For more information, see [Run
#' inference](https://docs.aws.amazon.com/bedrock/latest/userguide/inference.html)
#' in the Bedrock User Guide.
#' @param contentType The MIME type of the input data in the request. The default value is
#' `application/json`.
#' @param accept The desired MIME type of the inference body in the response. The default
#' value is `application/json`.
#' @param modelId &#91;required&#93; The unique identifier of the model to invoke to run inference.
#' 
#' The `modelId` to provide depends on the type of model that you use:
#' 
#' -   If you use a base model, specify the model ID or its ARN. For a list
#'     of model IDs for base models, see [Amazon Bedrock base model IDs
#'     (on-demand
#'     throughput)](https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a provisioned model, specify the ARN of the Provisioned
#'     Throughput. For more information, see [Run inference using a
#'     Provisioned
#'     Throughput](https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html)
#'     in the Amazon Bedrock User Guide.
#' 
#' -   If you use a custom model, first purchase Provisioned Throughput for
#'     it. Then specify the ARN of the resulting provisioned model. For
#'     more information, see [Use a custom model in Amazon
#'     Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html)
#'     in the Amazon Bedrock User Guide.
#' @param trace Specifies whether to enable or disable the Bedrock trace. If enabled,
#' you can see the full Bedrock trace.
#' @param guardrailIdentifier The unique identifier of the guardrail that you want to use. If you
#' don't provide a value, no guardrail is applied to the invocation.
#' 
#' An error is thrown in the following situations.
#' 
#' -   You don't provide a guardrail identifier but you specify the
#'     `amazon-bedrock-guardrailConfig` field in the request body.
#' 
#' -   You enable the guardrail but the `contentType` isn't
#'     `application/json`.
#' 
#' -   You provide a guardrail identifier, but `guardrailVersion` isn't
#'     specified.
#' @param guardrailVersion The version number for the guardrail. The value can also be `DRAFT`.
#'
#' @keywords internal
#'
#' @rdname bedrockruntime_invoke_model_with_response_stream
bedrockruntime_invoke_model_with_response_stream <- function(body, contentType = NULL, accept = NULL, modelId, trace = NULL, guardrailIdentifier = NULL, guardrailVersion = NULL) {
  op <- new_operation(
    name = "InvokeModelWithResponseStream",
    http_method = "POST",
    http_path = "/model/{modelId}/invoke-with-response-stream",
    paginator = list()
  )
  input <- .bedrockruntime$invoke_model_with_response_stream_input(body = body, contentType = contentType, accept = accept, modelId = modelId, trace = trace, guardrailIdentifier = guardrailIdentifier, guardrailVersion = guardrailVersion)
  output <- .bedrockruntime$invoke_model_with_response_stream_output()
  config <- get_config()
  svc <- .bedrockruntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockruntime$operations$invoke_model_with_response_stream <- bedrockruntime_invoke_model_with_response_stream
