% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_auto_ml_job_v2}
\alias{sagemaker_create_auto_ml_job_v2}
\title{Creates an Autopilot job also referred to as Autopilot experiment or
AutoML job V2}
\usage{
sagemaker_create_auto_ml_job_v2(
  AutoMLJobName,
  AutoMLJobInputDataConfig,
  OutputDataConfig,
  AutoMLProblemTypeConfig,
  RoleArn,
  Tags = NULL,
  SecurityConfig = NULL,
  AutoMLJobObjective = NULL,
  ModelDeployConfig = NULL,
  DataSplitConfig = NULL
)
}
\arguments{
\item{AutoMLJobName}{[required] Identifies an Autopilot job. The name must be unique to your account and
is case insensitive.}

\item{AutoMLJobInputDataConfig}{[required] An array of channel objects describing the input data and their
location. Each channel is a named input source. Similar to the
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig}{InputDataConfig}
attribute in the \code{\link[=sagemaker_create_auto_ml_job]{create_auto_ml_job}}
input parameters. The supported formats depend on the problem type:
\itemize{
\item For tabular problem types: \code{S3Prefix}, \code{ManifestFile}.
\item For image classification: \code{S3Prefix}, \code{ManifestFile},
\code{AugmentedManifestFile}.
\item For text classification: \code{S3Prefix}.
\item For time-series forecasting: \code{S3Prefix}.
}}

\item{OutputDataConfig}{[required] Provides information about encryption and the Amazon S3 output path
needed to store artifacts from an AutoML job.}

\item{AutoMLProblemTypeConfig}{[required] Defines the configuration settings of one of the supported problem
types.}

\item{RoleArn}{[required] The ARN of the role that is used to access the data.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, such as by purpose, owner, or
environment. For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web ServicesResources}.
Tag keys must be unique per resource.}

\item{SecurityConfig}{The security configuration for traffic encryption or Amazon VPC
settings.}

\item{AutoMLJobObjective}{Specifies a metric to minimize or maximize as the objective of a job. If
not specified, the default objective metric depends on the problem type.
For the list of default values per problem type, see
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html}{AutoMLJobObjective}.

For tabular problem types, you must either provide both the
\code{AutoMLJobObjective} and indicate the type of supervised learning
problem in \code{AutoMLProblemTypeConfig} (\code{TabularJobConfig.ProblemType}),
or none at all.}

\item{ModelDeployConfig}{Specifies how to generate the endpoint name for an automatic one-click
Autopilot model deployment.}

\item{DataSplitConfig}{This structure specifies how to split the data into train and validation
datasets.

The validation and training datasets must contain the same headers. For
jobs created by calling
\code{\link[=sagemaker_create_auto_ml_job]{create_auto_ml_job}}, the validation
dataset must be less than 2 GB in size.

This attribute must not be set for the time-series forecasting problem
type, as Autopilot automatically splits the input dataset into training
and validation sets.}
}
\description{
Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job_v2/} for full documentation.
}
\keyword{internal}
