% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_text}
\alias{rekognition_detect_text}
\title{Detects text in the input image and converts it into machine-readable
text}
\usage{
rekognition_detect_text(Image, Filters)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an Amazon S3 object. If you
use the AWS CLI to call Amazon Rekognition operations, you can\'t pass
image bytes.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{Filters}{Optional parameters that let you set the criteria that the text must
meet to be included in your response.}
}
\description{
Detects text in the input image and converts it into machine-readable
text.
}
\details{
Pass the input image as base64-encoded image bytes or as a reference to
an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
Rekognition operations, you must pass it as a reference to an image in
an Amazon S3 bucket. For the AWS CLI, passing image bytes is not
supported. The image must be either a .png or .jpeg formatted file.

The \code{DetectText} operation returns text in an array of TextDetection
elements, \code{TextDetections}. Each \code{TextDetection} element provides
information about a single word or line of text that was detected in the
image.

A word is one or more ISO basic latin script characters that are not
separated by spaces. \code{DetectText} can detect up to 50 words in an image.

A line is a string of equally spaced words. A line isn\'t necessarily a
complete sentence. For example, a driver\'s license number is detected
as a line. A line ends when there is no aligned text after it. Also, a
line ends when there is a large gap between words, relative to the
length of the words. This means, depending on the gap between words,
Amazon Rekognition may detect multiple lines in text aligned in the same
direction. Periods don\'t represent the end of a line. If a sentence
spans multiple lines, the \code{DetectText} operation returns multiple lines.

To determine whether a \code{TextDetection} element is a line of text or a
word, use the \code{TextDetection} object \code{Type} field.

To be detected, text must be within +/- 90 degrees orientation of the
horizontal axis.

For more information, see DetectText in the Amazon Rekognition Developer
Guide.
}
\section{Request syntax}{
\preformatted{svc$detect_text(
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  Filters = list(
    WordFilter = list(
      MinConfidence = 123.0,
      MinBoundingBoxHeight = 123.0,
      MinBoundingBoxWidth = 123.0
    ),
    RegionsOfInterest = list(
      list(
        BoundingBox = list(
          Width = 123.0,
          Height = 123.0,
          Left = 123.0,
          Top = 123.0
        )
      )
    )
  )
)
}
}

\keyword{internal}
