% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_vocabulary_filter}
\alias{transcribeservice_create_vocabulary_filter}
\title{Creates a new vocabulary filter that you can use to filter words, such
as profane words, from the output of a transcription job}
\usage{
transcribeservice_create_vocabulary_filter(VocabularyFilterName,
  LanguageCode, Words, VocabularyFilterFileUri)
}
\arguments{
\item{VocabularyFilterName}{[required] The vocabulary filter name. The name must be unique within the account
that contains it.}

\item{LanguageCode}{[required] The language code of the words in the vocabulary filter. All words in
the filter must be in the same language. The vocabulary filter can only
be used with transcription jobs in the specified language.}

\item{Words}{The words to use in the vocabulary filter. Only use characters from the
character set defined for custom vocabularies. For a list of character
sets, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets}{Character Sets for Custom Vocabularies}.

If you provide a list of words in the \code{Words} parameter, you can\'t use
the \code{VocabularyFilterFileUri} parameter.}

\item{VocabularyFilterFileUri}{The Amazon S3 location of a text file used as input to create the
vocabulary filter. Only use characters from the character set defined
for custom vocabularies. For a list of character sets, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets}{Character Sets for Custom Vocabularies}.

The specified file must be less than 50 KB of UTF-8 characters.

If you provide the location of a list of words in the
\code{VocabularyFilterFileUri} parameter, you can\'t use the \code{Words}
parameter.}
}
\description{
Creates a new vocabulary filter that you can use to filter words, such
as profane words, from the output of a transcription job.
}
\section{Request syntax}{
\preformatted{svc$create_vocabulary_filter(
  VocabularyFilterName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA"|"ru-RU"|"zh-CN"|"nl-NL"|"id-ID"|"ta-IN"|"fa-IR"|"en-IE"|"en-AB"|"en-WL"|"pt-PT"|"te-IN"|"tr-TR"|"de-CH"|"he-IL"|"ms-MY"|"ja-JP"|"ar-AE",
  Words = list(
    "string"
  ),
  VocabularyFilterFileUri = "string"
)
}
}

\keyword{internal}
