% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_delete_campaign}
\alias{personalize_delete_campaign}
\title{Removes a campaign by deleting the solution deployment}
\usage{
personalize_delete_campaign(campaignArn)
}
\arguments{
\item{campaignArn}{[required] The Amazon Resource Name (ARN) of the campaign to delete.}
}
\description{
Removes a campaign by deleting the solution deployment. The solution
that the campaign is based on is not deleted and can be redeployed when
needed. A deleted campaign can no longer be specified in a
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html}{GetRecommendations}
request. For more information on campaigns, see CreateCampaign.
}
\section{Request syntax}{
\preformatted{svc$delete_campaign(
  campaignArn = "string"
)
}
}

\keyword{internal}
