% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_models}
\alias{sagemaker_list_models}
\title{Lists models created with the CreateModel API}
\usage{
sagemaker_list_models(SortBy, SortOrder, NextToken, MaxResults,
  NameContains, CreationTimeBefore, CreationTimeAfter)
}
\arguments{
\item{SortBy}{Sorts the list of results. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Descending}.}

\item{NextToken}{If the response to a previous \code{\link[=sagemaker_list_models]{list_models}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of models, use the token in the next request.}

\item{MaxResults}{The maximum number of models to return in the response.}

\item{NameContains}{A string in the training job name. This filter returns only models in
the training job whose name contains the specified string.}

\item{CreationTimeBefore}{A filter that returns only models created before the specified time
(timestamp).}

\item{CreationTimeAfter}{A filter that returns only models with a creation time greater than or
equal to the specified time (timestamp).}
}
\value{
A list with the following syntax:\preformatted{list(
  Models = list(
    list(
      ModelName = "string",
      ModelArn = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists models created with the \code{\link[=sagemaker_create_model]{create_model}}
API.
}
\section{Request syntax}{
\preformatted{svc$list_models(
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123,
  NameContains = "string",
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
