% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_get_speech_synthesis_task}
\alias{polly_get_speech_synthesis_task}
\title{Retrieves a specific SpeechSynthesisTask object based on its TaskID}
\usage{
polly_get_speech_synthesis_task(TaskId)
}
\arguments{
\item{TaskId}{[required] The Amazon Polly generated identifier for a speech synthesis task.}
}
\value{
A list with the following syntax:\preformatted{list(
  SynthesisTask = list(
    Engine = "standard"|"neural",
    TaskId = "string",
    TaskStatus = "scheduled"|"inProgress"|"completed"|"failed",
    TaskStatusReason = "string",
    OutputUri = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    RequestCharacters = 123,
    SnsTopicArn = "string",
    LexiconNames = list(
      "string"
    ),
    OutputFormat = "json"|"mp3"|"ogg_vorbis"|"pcm",
    SampleRate = "string",
    SpeechMarkTypes = list(
      "sentence"|"ssml"|"viseme"|"word"
    ),
    TextType = "ssml"|"text",
    VoiceId = "Aditi"|"Amy"|"Astrid"|"Bianca"|"Brian"|"Camila"|"Carla"|"Carmen"|"Celine"|"Chantal"|"Conchita"|"Cristiano"|"Dora"|"Emma"|"Enrique"|"Ewa"|"Filiz"|"Geraint"|"Giorgio"|"Gwyneth"|"Hans"|"Ines"|"Ivy"|"Jacek"|"Jan"|"Joanna"|"Joey"|"Justin"|"Karl"|"Kendra"|"Kevin"|"Kimberly"|"Lea"|"Liv"|"Lotte"|"Lucia"|"Lupe"|"Mads"|"Maja"|"Marlene"|"Mathieu"|"Matthew"|"Maxim"|"Mia"|"Miguel"|"Mizuki"|"Naja"|"Nicole"|"Olivia"|"Penelope"|"Raveena"|"Ricardo"|"Ruben"|"Russell"|"Salli"|"Seoyeon"|"Takumi"|"Tatyana"|"Vicki"|"Vitoria"|"Zeina"|"Zhiyu",
    LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR"
  )
)
}
}
\description{
Retrieves a specific SpeechSynthesisTask object based on its TaskID.
This object contains information about the given speech synthesis task,
including the status of the task, and a link to the S3 bucket containing
the output of the task.
}
\section{Request syntax}{
\preformatted{svc$get_speech_synthesis_task(
  TaskId = "string"
)
}
}

\keyword{internal}
