% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_get_transcription_job}
\alias{transcribeservice_get_transcription_job}
\title{Returns information about a transcription job}
\usage{
transcribeservice_get_transcription_job(TranscriptionJobName)
}
\arguments{
\item{TranscriptionJobName}{[required] The name of the job.}
}
\value{
A list with the following syntax:\preformatted{list(
  TranscriptionJob = list(
    TranscriptionJobName = "string",
    TranscriptionJobStatus = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
    LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
    MediaSampleRateHertz = 123,
    MediaFormat = "mp3"|"mp4"|"wav"|"flac"|"ogg"|"amr"|"webm",
    Media = list(
      MediaFileUri = "string"
    ),
    Transcript = list(
      TranscriptFileUri = "string",
      RedactedTranscriptFileUri = "string"
    ),
    StartTime = as.POSIXct(
      "2015-01-01"
    ),
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    CompletionTime = as.POSIXct(
      "2015-01-01"
    ),
    FailureReason = "string",
    Settings = list(
      VocabularyName = "string",
      ShowSpeakerLabels = TRUE|FALSE,
      MaxSpeakerLabels = 123,
      ChannelIdentification = TRUE|FALSE,
      ShowAlternatives = TRUE|FALSE,
      MaxAlternatives = 123,
      VocabularyFilterName = "string",
      VocabularyFilterMethod = "remove"|"mask"
    ),
    ModelSettings = list(
      LanguageModelName = "string"
    ),
    JobExecutionSettings = list(
      AllowDeferredExecution = TRUE|FALSE,
      DataAccessRoleArn = "string"
    ),
    ContentRedaction = list(
      RedactionType = "PII",
      RedactionOutput = "redacted"|"redacted_and_unredacted"
    ),
    IdentifyLanguage = TRUE|FALSE,
    LanguageOptions = list(
      "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN"
    ),
    IdentifiedLanguageScore = 123.0
  )
)
}
}
\description{
Returns information about a transcription job. To see the status of the
job, check the \code{TranscriptionJobStatus} field. If the status is
\code{COMPLETED}, the job is finished and you can find the results at the
location specified in the \code{TranscriptFileUri} field. If you enable
content redaction, the redacted transcript appears in
\code{RedactedTranscriptFileUri}.
}
\section{Request syntax}{
\preformatted{svc$get_transcription_job(
  TranscriptionJobName = "string"
)
}
}

\keyword{internal}
